<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Construction Floors')); ?> - <?php echo e($project->project_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('projects.index')); ?>"><?php echo e(__('Projects')); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('projects.show', $project->id)); ?>"><?php echo e($project->project_name); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Construction Floors')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('action-btn'); ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create project')): ?>
        <div class="float-end">
            <a href="#" data-url="<?php echo e(route('construction.floors.create', $project->id)); ?>" data-ajax-popup="true"
                data-title="<?php echo e(__('Create Construction Floor')); ?>" data-size="md" class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i> <?php echo e(__('Create Floor')); ?>

            </a>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-page'); ?>
    <script src="<?php echo e(asset('assets/js/jquery-ui.min.js')); ?>"></script>
    <script>
        $(function () {
            $(".sortable").sortable({
                handle: '.sort-handle',
                stop: function () {
                    var order = [];
                    $(this).find('li').each(function (index, data) {
                        order[index] = $(data).attr('data-id');
                    });
                    $.ajax({
                        url: "<?php echo e(route('construction.floors.order', $project->id)); ?>",
                        data: { order: order, _token: '<?php echo e(csrf_token()); ?>' },
                        type: 'POST',
                        success: function (data) {
                            show_toastr('<?php echo e(__("Success")); ?>', '<?php echo e(__("Order updated successfully")); ?>', 'success');
                        },
                        error: function (data) {
                            show_toastr('<?php echo e(__("Error")); ?>', '<?php echo e(__("Something went wrong")); ?>', 'error');
                        }
                    });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5><?php echo e(__('Construction Floors')); ?></h5>
                    <small class="text-muted"><?php echo e(__('Drag and drop to reorder floors')); ?></small>
                </div>
                <div class="card-body">
                    <?php if($floors->count() > 0): ?>
                        <ul class="list-group sortable">
                            <?php $__currentLoopData = $floors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $floor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="list-group-item" data-id="<?php echo e($floor->id); ?>">
                                    <div class="row align-items-center">
                                        <div class="col-auto">
                                            <span class="sort-handle" style="cursor: move;">
                                                <i class="ti ti-grip-vertical"></i>
                                            </span>
                                        </div>
                                        <div class="col">
                                            <h6 class="mb-0"><?php echo e($floor->name); ?></h6>
                                            <?php if($floor->description): ?>
                                                <small class="text-muted"><?php echo e($floor->description); ?></small>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col-auto">
                                            <h6 class="mb-0"><?php echo e($floor->stages->count()); ?></h6>
                                            <small class="text-muted"><?php echo e(__('Stages')); ?></small>
                                        </div>
                                        <div class="col-auto text-end">
                                            <div class="d-flex justify-content-end align-items-center gap-2 flex-nowrap">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit project')): ?>
                                                    <div class="action-btn bg-primary">
                                                        <a href="#" data-url="<?php echo e(route('construction.floors.edit', $floor->id)); ?>"
                                                            data-ajax-popup="true" data-title="<?php echo e(__('Edit Construction Floor')); ?>"
                                                            data-size="md" class="btn btn-sm d-inline-flex align-items-center"
                                                            data-bs-toggle="tooltip" title="<?php echo e(__('Edit')); ?>">
                                                            <i class="ti ti-pencil text-white"></i>
                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete project')): ?>
                                                    <div class="action-btn bg-danger">
                                                        <?php echo Form::open(['method' => 'DELETE', 'route' => ['construction.floors.destroy', $floor->id], 'class' => 'd-inline']); ?>

                                                        <a href="#" class="btn btn-sm d-inline-flex align-items-center bs-pass-para"
                                                            data-bs-toggle="tooltip" title="<?php echo e(__('Delete')); ?>">
                                                            <i class="ti ti-trash text-white"></i>
                                                        </a>
                                                        <?php echo Form::close(); ?>

                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="ti ti-layers-union" style="font-size: 48px; opacity: 0.3;"></i>
                            <p class="text-muted mt-3"><?php echo e(__('No construction floors found.')); ?></p>
                            <p class="text-muted"><?php echo e(__('Click "Create Floor" button above to add your first floor.')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/construction/resources/views/projects/construction/floors/index.blade.php ENDPATH**/ ?>