<?php echo e(Form::open(['route' => ['construction.stages.store', $project->id], 'method' => 'post'])); ?>

<div class="modal-body">
    <div class="row">
        <div class="form-group col-md-12">
            <?php echo e(Form::label('construction_floor_id', __('Floor (Optional)'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::select('construction_floor_id', $floors, null, ['class' => 'form-control select', 'placeholder' => __('Select Floor')])); ?>

        </div>
        <div class="form-group col-md-12">
            <?php echo e(Form::label('name', __('Stage Name'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('name', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => __('e.g., Foundation Work')])); ?>

        </div>

        <div class="form-group col-md-12">
            <?php echo e(Form::label('description', __('Description'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::textarea('description', null, ['class' => 'form-control', 'rows' => 3, 'placeholder' => __('Describe this construction stage...')])); ?>

        </div>

        <div class="form-group col-md-6">
            <?php echo e(Form::label('budget_allocated', __('Budget Allocated (Optional)'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::number('budget_allocated', null, ['class' => 'form-control', 'step' => '0.01', 'min' => '0', 'placeholder' => '0.00'])); ?>

            <small class="text-muted"><?php echo e(__('Leave blank if budget is not known yet')); ?></small>
        </div>

        <div class="form-group col-md-6">
            <?php echo e(Form::label('status', __('Status'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::select('status', \App\Models\ConstructionStage::$statuses, 'pending', ['class' => 'form-control select'])); ?>

        </div>

        <div class="form-group col-md-6">
            <?php echo e(Form::label('start_date', __('Start Date'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::date('start_date', null, ['class' => 'form-control'])); ?>

        </div>

        <div class="form-group col-md-6">
            <?php echo e(Form::label('end_date', __('End Date'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::date('end_date', null, ['class' => 'form-control'])); ?>

        </div>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-light" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
    <button type="submit" class="btn btn-primary"><?php echo e(__('Create')); ?></button>
</div>
<?php echo e(Form::close()); ?><?php /**PATH /Applications/MAMP/htdocs/construction/resources/views/construction/stages/create.blade.php ENDPATH**/ ?>