<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Create Budget Planner')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('budget.index')); ?>"><?php echo e(__('Budget Planner')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Budget Create')); ?></li>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script-page'); ?>
    <script src="<?php echo e(asset('js/jquery-ui.min.js')); ?>"></script>
    <script>
        //Income Total
        $(document).on('keyup', '.income_data', function () {
            //category wise total
            var el = $(this).parent().parent();
            var inputs = $(el.find('.income_data'));

            var totalincome = 0;
            for (var i = 0; i < inputs.length; i++) {
                var price = $(inputs[i]).val();
                totalincome = parseFloat(totalincome) + parseFloat(price);
            }
            el.find('.totalIncome').html(totalincome);

            // month wise total //
            var month_income = $(this).data('month');
            var month_inputs = $(el.parent().find('.' + month_income+'_income'));
            var month_totalincome = 0;
            for (var i = 0; i < month_inputs.length; i++) {
                var month_price = $(month_inputs[i]).val();
                month_totalincome = parseFloat(month_totalincome) + parseFloat(month_price);
            }
            var month_total_income = month_income + '_total_income';
            el.parent().find('.' + month_total_income).html(month_totalincome);

            //all total //
            var total_inputs = $(el.parent().find('.totalIncome'));
            console.log(total_inputs)
            var income = 0;
            for (var i = 0; i < total_inputs.length; i++) {
                var price = $(total_inputs[i]).html();
                income = parseFloat(income) + parseFloat(price);
            }
            el.parent().find('.income').html(income);

        })


        //Expense Total
        $(document).on('keyup', '.expense_data', function () {
            //category wise total
            var el = $(this).parent().parent();
            var inputs = $(el.find('.expense_data'));

            var totalexpense = 0;
            for (var i = 0; i < inputs.length; i++) {
                var price = $(inputs[i]).val();
                totalexpense = parseFloat(totalexpense) + parseFloat(price);
            }
            el.find('.totalExpense').html(totalexpense);

            // month wise total //
            var month_expense = $(this).data('month');
            var month_inputs = $(el.parent().find('.' + month_expense+'_expense'));
            var month_totalexpense = 0;
            for (var i = 0; i < month_inputs.length; i++) {
                var month_price = $(month_inputs[i]).val();
                month_totalexpense = parseFloat(month_totalexpense) + parseFloat(month_price);
            }
            var month_total_expense = month_expense + '_total_expense';
            el.parent().find('.' + month_total_expense).html(month_totalexpense);

            //all total //
            var total_inputs = $(el.parent().find('.totalExpense'));
            console.log(total_inputs)
            var expense = 0;
            for (var i = 0; i < total_inputs.length; i++) {
                var price = $(total_inputs[i]).html();
                expense = parseFloat(expense) + parseFloat(price);
            }
            el.parent().find('.expense').html(expense);

        })

        //Hide & Show
        $(document).on('change', '.period', function() {
            var period = $(this).val();

            $('.budget_plan').removeClass('d-block');
            $('.budget_plan').addClass('d-none');
            $('#'+ period).removeClass('d-none');
            $('#'+ period).addClass('d-block');



        });




    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

    <div class="card bg-none card-box mt-3">
        <div class="card-body">
            <?php echo e(Form::open(array('url' => 'budget','class'=>'w-100', 'class'=>'needs-validation', 'novalidate'))); ?>

            <div class="row">

                <div class="form-group col-md-4">
                    <?php echo e(Form::label('name', __('Name'),['class'=>'form-label'])); ?><?php if (isset($component)) { $__componentOriginalbba606fec37ea04333bc269e3e165587 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbba606fec37ea04333bc269e3e165587 = $attributes; } ?>
<?php $component = App\View\Components\Required::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('required'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Required::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbba606fec37ea04333bc269e3e165587)): ?>
<?php $attributes = $__attributesOriginalbba606fec37ea04333bc269e3e165587; ?>
<?php unset($__attributesOriginalbba606fec37ea04333bc269e3e165587); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbba606fec37ea04333bc269e3e165587)): ?>
<?php $component = $__componentOriginalbba606fec37ea04333bc269e3e165587; ?>
<?php unset($__componentOriginalbba606fec37ea04333bc269e3e165587); ?>
<?php endif; ?>
                    <?php echo e(Form::text('name',null, array('class' => 'form-control','required'=>'required' , 'placeholder' => __('Enter Name')))); ?>

                </div>

                <div class="form-group col-md-4">
                    <?php echo e(Form::label('period', __('Budget Period'),['class'=>'form-label'])); ?><?php if (isset($component)) { $__componentOriginalbba606fec37ea04333bc269e3e165587 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalbba606fec37ea04333bc269e3e165587 = $attributes; } ?>
<?php $component = App\View\Components\Required::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('required'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Required::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalbba606fec37ea04333bc269e3e165587)): ?>
<?php $attributes = $__attributesOriginalbba606fec37ea04333bc269e3e165587; ?>
<?php unset($__attributesOriginalbba606fec37ea04333bc269e3e165587); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalbba606fec37ea04333bc269e3e165587)): ?>
<?php $component = $__componentOriginalbba606fec37ea04333bc269e3e165587; ?>
<?php unset($__componentOriginalbba606fec37ea04333bc269e3e165587); ?>
<?php endif; ?>
                    <?php echo e(Form::select('period', $periods,null, array('class' => 'form-control select period','required'=>'required'))); ?>


                </div>

                <div class="form-group  col-md-4">
                    <div class="btn-box">
                        <?php echo e(Form::label('year', __('Year'),['class'=>'form-label'])); ?>

                        <?php echo e(Form::select('year',$yearList,isset($_GET['year'])?$_GET['year']:'', array('class' => 'form-control select'))); ?>

                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="col-12">
        <div class="card">
            <div class="card-body table-border-style">

                <!---- Start Monthly Budget ------------------------------------------------------------------------>
                <div class="table-responsive budget_plan d-block"  id="monthly">
                    <table class="table  mb-0" id="dataTable-manual">
                        <thead>
                        <tr>
                            <th><?php echo e(__('Category')); ?></th>
                            <?php $__currentLoopData = $monthList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td class="total text-dark"><?php echo e($month); ?></td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <th><?php echo e(__('Total :')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <!------------------   Income Category ----------------------------------->
                        <tr>
                            <th colspan="14" class="text-dark light_blue"><span><?php echo e(__('Income :')); ?></span></th>
                        </tr>

                        <?php $__currentLoopData = $incomeproduct; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($productService->name); ?></td>
                                <?php $__currentLoopData = $monthList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td>
                                        <input type="number" class="form-control pl-1 pr-1 income_data <?php echo e($month); ?>_income" data-month="<?php echo e($month); ?>" name="income[<?php echo e($productService->id); ?>][<?php echo e($month); ?>]" value="0" id="income_data_<?php echo e($month); ?>">
                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <td class="totalIncome text-dark">
                                    0.00
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td class="text-dark"><?php echo e(__('Total :')); ?></td>
                            <?php $__currentLoopData = $monthList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td>
                                    <span class="<?php echo e($month); ?>_total_income text-dark">0.00</span>
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <span class="income text-dark">0.00</span>
                            </td>
                        </tr>

                        <!------------------   Expense Category ----------------------------------->

                        <tr>
                            <th colspan="14" class="text-dark light_blue"><span><?php echo e(__('Expense :')); ?></span></th>
                        </tr>

                        <?php $__currentLoopData = $expenseproduct; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($productService->name); ?></td>
                                <?php $__currentLoopData = $monthList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td>
                                        <input type="number" class="form-control pl-1 pr-1 expense_data <?php echo e($month); ?>_expense" data-month="<?php echo e($month); ?>" name="expense[<?php echo e($productService->id); ?>][<?php echo e($month); ?>]" value="0" id="expense_data_<?php echo e($month); ?>">
                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <td class="totalExpense text-dark">
                                    0.00
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td  class="text-dark"><?php echo e(__('Total :')); ?></span></td>
                            <?php $__currentLoopData = $monthList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td>
                                    <span class="<?php echo e($month); ?>_total_expense text-dark">0.00</span>
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <td>
                                <span class="expense text-dark">0.00</span>
                            </td>

                        </tr>

                        </tbody>

                    </table>

                    <div class="modal-footer budget">
                        <input type="button" value="<?php echo e(__('Cancel')); ?>" onclick="location.href = '<?php echo e(route("budget.index")); ?>';" class="btn btn-secondary">
                        <input type="submit" value="<?php echo e(__('Create')); ?>" class="btn  btn-primary">
                    </div>

                </div>

                <!---- End Monthly Budget ----->


                <!---- Start Quarterly Budget ----------------------------------------------------------------------->
                <div class="table-responsive budget_plan d-none" id="quarterly">
                    <table class="table mb-0" id="dataTable-manual">
                        <thead>
                        <tr>
                            <th><?php echo e(__('Category')); ?></th>
                            <?php $__currentLoopData = $quarterly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td class="total text-dark"><?php echo e($month); ?></td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <th><?php echo e(__('Total :')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <!------------------   Income Category ----------------------------------->
                        <tr>
                            <th colspan="37" class="text-dark light_blue"><span><?php echo e(__('Income :')); ?></span></th>
                        </tr>

                        <?php $__currentLoopData = $incomeproduct; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($productService->name); ?></td>
                                <?php $__currentLoopData = $quarterly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td>
                                        <input type="number" class="form-control income_data <?php echo e($month); ?>_income" data-month="<?php echo e($month); ?>"
                                               name="income[<?php echo e($productService->id); ?>][<?php echo e($month); ?>]" value="0" id="income_data_<?php echo e($month); ?>">
                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <td class="text-end totalIncome  text-dark">
                                    0.00
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td class="text-dark"><?php echo e(__('Total :')); ?></td>
                            <?php $__currentLoopData = $quarterly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td>
                                    <span class="<?php echo e($month); ?>_total_income  text-dark">0.00</span>
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <td class="text-end">
                                <span class="income  text-dark">0.00</span>
                            </td>
                        </tr>



                        <!------------------   Expense Category ----------------------------------->

                        <tr>
                            <th colspan="14" class="text-dark light_blue"><span><?php echo e(__('Expense :')); ?></span></th>
                        </tr>

                        <?php $__currentLoopData = $expenseproduct; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($productService->name); ?></td>
                                <?php $__currentLoopData = $quarterly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td>
                                        <input type="number" class="form-control expense_data <?php echo e($month); ?>_expense" data-month="<?php echo e($month); ?>" name="expense[<?php echo e($productService->id); ?>][<?php echo e($month); ?>]" value="0" id="expense_data_<?php echo e($month); ?>">
                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <td class="text-end totalExpense  text-dark">
                                    0.00
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td  class="text-dark"><?php echo e(__('Total :')); ?></span></td>
                            <?php $__currentLoopData = $quarterly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td>
                                    <span class="<?php echo e($month); ?>_total_expense  text-dark">0.00</span>
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <td class="text-end">
                                <span class="expense  text-dark">0.00</span>
                            </td>

                        </tr>

                        </tbody>

                    </table>
                    <div class="modal-footer budget">
                        <input type="button" value="<?php echo e(__('Cancel')); ?>" onclick="location.href = '<?php echo e(route("budget.index")); ?>';" class="btn btn-secondary">
                        <input type="submit" value="<?php echo e(__('Create')); ?>" class="btn  btn-primary">
                    </div>
                </div>

                <!---- End Quarterly Budget ----->


                <!---Start Half-Yearly Budget --------------------------------------------------------------------->
                <div class="table-responsive budget_plan d-none" id="half-yearly">
                    <table class="table  mb-0" id="dataTable-manual">
                        <thead>
                        <tr>
                            <th><?php echo e(__('Category')); ?></th>
                            <?php $__currentLoopData = $half_yearly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td class="total text-dark"><?php echo e($month); ?></td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <th><?php echo e(__('Total :')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <!------------------   Income Category ----------------------------------->
                        <tr>
                            <th colspan="14" class="text-dark light_blue"><span><?php echo e(__('Income :')); ?></span></th>
                        </tr>

                        <?php $__currentLoopData = $incomeproduct; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($productService->name); ?></td>
                                <?php $__currentLoopData = $half_yearly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td>
                                        <input type="number" class="form-control income_data <?php echo e($month); ?>_income" data-month="<?php echo e($month); ?>" name="income[<?php echo e($productService->id); ?>][<?php echo e($month); ?>]" value="0" id="income_data_<?php echo e($month); ?>">
                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <td class="text-end totalIncome  text-dark">
                                    0.00
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td class="text-dark"><?php echo e(__('Total :')); ?></td>
                            <?php $__currentLoopData = $half_yearly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td>
                                    <span class="<?php echo e($month); ?>_total_income  text-dark">0.00</span>
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <td class="text-end">
                                <span class="income text-dark">0.00</span>
                            </td>
                        </tr>

                        <!------------------   Expense Category ----------------------------------->

                        <tr>
                            <th colspan="14" class="text-dark light_blue"><span><?php echo e(__('Expense :')); ?></span></th>
                        </tr>

                        <?php $__currentLoopData = $expenseproduct; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($productService->name); ?></td>
                                <?php $__currentLoopData = $half_yearly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td>
                                        <input type="number" class="form-control expense_data <?php echo e($month); ?>_expense" data-month="<?php echo e($month); ?>" name="expense[<?php echo e($productService->id); ?>][<?php echo e($month); ?>]" value="0" id="expense_data_<?php echo e($month); ?>">
                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <td class="text-end totalExpense text-dark">
                                    0.00
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td  class="text-dark"><?php echo e(__('Total :')); ?></span></td>
                            <?php $__currentLoopData = $half_yearly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td>
                                    <span class="<?php echo e($month); ?>_total_expense text-dark">0.00</span>
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <td class="text-end">
                                <span class="expense text-dark">0.00</span>
                            </td>

                        </tr>

                        </tbody>

                    </table>
                    <div class="modal-footer budget">
                        <input type="button" value="<?php echo e(__('Cancel')); ?>" onclick="location.href = '<?php echo e(route("budget.index")); ?>';" class="btn btn-secondary">
                        <input type="submit" value="<?php echo e(__('Create')); ?>" class="btn  btn-primary">
                    </div>
                </div>

                <!---End Half-Yearly Budget ----->

                <!---Start Yearly Budget --------------------------------------------------------------------------------->
                <div class="table-responsive budget_plan d-none" id="yearly">
                    <table class="table  mb-0" id="dataTable-manual">
                        <thead>
                        <tr>
                            <th><?php echo e(__('Category')); ?></th>
                            <?php $__currentLoopData = $yearly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td class="total text-dark"><?php echo e($month); ?></td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <th><?php echo e(__('Total :')); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <!------------------   Income Category ----------------------------------->
                        <tr>
                            <th colspan="14" class="text-dark light_blue"><span><?php echo e(__('Income :')); ?></span></th>
                        </tr>

                        <?php $__currentLoopData = $incomeproduct; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($productService->name); ?></td>

                                <?php $__currentLoopData = $yearly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                    <td>
                                        <input type="number" class="form-control income_data <?php echo e($month); ?>_income" data-month="<?php echo e($month); ?>" name="income[<?php echo e($productService->id); ?>][<?php echo e($month); ?>]" value="<?php echo e(!empty($budget['income_data'][$productService->id][$month])?$budget['income_data'][$productService->id][$month]:0); ?>" id="income_data_<?php echo e($month); ?>">
                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <td class="text-end totalIncome text-dark">
                                    0.00
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td class="text-dark"><?php echo e(__('Total :')); ?></td>
                            <?php $__currentLoopData = $yearly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td>
                                    <span class="<?php echo e($month); ?>_total_income text-dark">0.00</span>
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <td class="text-end">
                                <span class="income text-dark">0.00</span>
                            </td>
                        </tr>

                        <!------------------   Expense Category ----------------------------------->

                        <tr>
                            <th colspan="14" class="text-dark light_blue"><span><?php echo e(__('Expense :')); ?></span></th>
                        </tr>

                        <?php $__currentLoopData = $expenseproduct; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productService): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($productService->name); ?></td>
                                <?php $__currentLoopData = $yearly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td>
                                        <input type="number" class="form-control expense_data <?php echo e($month); ?>_expense" data-month="<?php echo e($month); ?>" name="expense[<?php echo e($productService->id); ?>][<?php echo e($month); ?>]" value="<?php echo e(!empty($budget['expense_data'][$productService->id][$month])?$budget['expense_data'][$productService->id][$month]:0); ?>" id="expense_data_<?php echo e($month); ?>">
                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <td class="text-end totalExpense text-dark">
                                    0.00
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <tr>
                            <td  class="text-dark"><?php echo e(__('Total :')); ?></span></td>
                            <?php $__currentLoopData = $yearly_monthlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $month): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td>
                                    <span class="<?php echo e($month); ?>_total_expense text-dark">0.00</span>
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <td class="text-end">
                                <span class="expense text-dark">0.00</span>
                            </td>

                        </tr>

                        </tbody>

                    </table>
                    <div class="modal-footer budget">
                        <input type="button" value="<?php echo e(__('Cancel')); ?>" onclick="location.href = '<?php echo e(route("budget.index")); ?>';" class="btn btn-secondary">
                        <input type="submit" value="<?php echo e(__('Create')); ?>" class="btn  btn-primary">
                    </div>
                </div>

                <!---End Yearly Budget ----->



            </div>
            <?php echo e(Form::close()); ?>

        </div>
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/construction/resources/views/budget/create.blade.php ENDPATH**/ ?>