<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Construction Stages')); ?> - <?php echo e($project->project_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('projects.index')); ?>"><?php echo e(__('Projects')); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('projects.show', $project->id)); ?>"><?php echo e($project->project_name); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Construction Stages')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('action-btn'); ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create project')): ?>
        <div class="float-end">
            <a href="<?php echo e(route('construction.gantt', $project->id)); ?>" class="btn btn-sm btn-info me-1">
                <i class="ti ti-calendar-time"></i> <?php echo e(__('Gantt Chart')); ?>

            </a>
            <a href="#" data-url="<?php echo e(route('construction.stages.library', $project->id)); ?>" data-ajax-popup="true"
                data-title="<?php echo e(__('Import from Library')); ?>" data-size="lg" class="btn btn-sm btn-light-primary me-1">
                <i class="ti ti-download"></i> <?php echo e(__('Import')); ?>

            </a>
            <a href="#" data-url="<?php echo e(route('construction.stages.create', $project->id)); ?>" data-ajax-popup="true"
                data-title="<?php echo e(__('Create Construction Stage')); ?>" data-size="lg" class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i> <?php echo e(__('Create Stage')); ?>

            </a>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-page'); ?>
    <script src="<?php echo e(asset('assets/js/jquery-ui.min.js')); ?>"></script>
    <script>
        $(function () {
            $(".sortable").sortable({
                handle: '.sort-handle',
                stop: function () {
                    var order = [];
                    $(this).find('li').each(function (index, data) {
                        order[index] = $(data).attr('data-id');
                    });
                    $.ajax({
                        url: "<?php echo e(route('construction.stages.order', $project->id)); ?>",
                        data: { order: order, _token: '<?php echo e(csrf_token()); ?>' },
                        type: 'POST',
                        success: function (data) {
                            show_toastr('<?php echo e(__("Success")); ?>', '<?php echo e(__("Order updated successfully")); ?>', 'success');
                        },
                        error: function (data) {
                            show_toastr('<?php echo e(__("Error")); ?>', '<?php echo e(__("Something went wrong")); ?>', 'error');
                        }
                    });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<?php ($settings = \App\Models\Utility::settings()); ?>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5><?php echo e(__('Project Budget Overview')); ?></h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h6 class="text-muted"><?php echo e(__('Total Budget Allocated')); ?></h6>
                            <h4 class="text-primary">
                                <?php if($project->getTotalConstructionBudget() > 0): ?>
                                    <?php echo e(Utility::priceFormat($settings, $project->getTotalConstructionBudget())); ?>

                                <?php else: ?>
                                    <span class="text-muted"><?php echo e(__('Not Set')); ?></span>
                                <?php endif; ?>
                            </h4>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h6 class="text-muted"><?php echo e(__('Total Spent')); ?></h6>
                            <h4 class="text-info">
                                <?php echo e(Utility::priceFormat($settings, $project->getTotalConstructionSpent())); ?>

                            </h4>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h6 class="text-muted"><?php echo e(__('Remaining Budget')); ?></h6>
                            <h4
                                class="<?php echo e($project->getTotalConstructionBudget() > 0 && $project->getTotalConstructionSpent() > $project->getTotalConstructionBudget() ? 'text-danger' : 'text-success'); ?>">
                                <?php if($project->getTotalConstructionBudget() > 0): ?>
                                    <?php echo e(Utility::priceFormat($settings, $project->getTotalConstructionBudget() - $project->getTotalConstructionSpent())); ?>

                                <?php else: ?>
                                    <span class="text-muted"><?php echo e(__('N/A')); ?></span>
                                <?php endif; ?>
                            </h4>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h6 class="text-muted"><?php echo e(__('Overall Progress')); ?></h6>
                            <h4 class="text-success"><?php echo e($project->getConstructionProgress()); ?>%</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5><?php echo e(__('Construction Stages')); ?></h5>
                <small class="text-muted"><?php echo e(__('Drag and drop to reorder stages')); ?></small>
            </div>
            <div class="card-body">
                <?php if($floors->count() > 0 || $stages->count() > 0): ?>
                    <div class="accordion" id="accordionFloors">
                        <?php $__currentLoopData = $floors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $floor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="accordion-item mb-3">
                                <h2 class="accordion-header" id="heading<?php echo e($floor->id); ?>">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapse<?php echo e($floor->id); ?>" aria-expanded="true"
                                        aria-controls="collapse<?php echo e($floor->id); ?>">
                                        <div class="d-flex justify-content-between w-100 align-items-center me-3">
                                            <div>
                                                <i class="ti ti-layers-intersect me-2"></i> <?php echo e($floor->name); ?>

                                            </div>
                                            <div class="text-end">
                                                <small class="text-muted d-block"><?php echo e(__('Total Budget')); ?></small>
                                                <span class="text-primary font-weight-bold">
                                                    <?php echo e(Utility::priceFormat($settings, $floor->stages->sum('budget_allocated'))); ?>

                                                </span>
                                            </div>
                                        </div>
                                    </button>
                                </h2>
                                <div id="collapse<?php echo e($floor->id); ?>" class="accordion-collapse collapse show"
                                    aria-labelledby="heading<?php echo e($floor->id); ?>">
                                    <div class="accordion-body p-0">
                                        <?php if($floor->stages->count() > 0): ?>
                                            <ul class="list-group list-group-flush sortable" data-floor-id="<?php echo e($floor->id); ?>">
                                                <?php $__currentLoopData = $floor->stages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php echo $__env->make('construction.stages.section_stage_row', ['stage' => $stage, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </ul>
                                        <?php else: ?>
                                            <div class="text-center py-3">
                                                <small class="text-muted"><?php echo e(__('No stages assigned to this floor yet.')); ?></small>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        <?php if($stages->count() > 0): ?>
                            <div class="accordion-item mb-3">
                                <h2 class="accordion-header" id="headingUnassigned">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseUnassigned" aria-expanded="true"
                                        aria-controls="collapseUnassigned">
                                        <div class="d-flex justify-content-between w-100 align-items-center me-3">
                                            <div>
                                                <i class="ti ti-package me-2"></i> <?php echo e(__('General / Unassigned')); ?>

                                            </div>
                                        </div>
                                    </button>
                                </h2>
                                <div id="collapseUnassigned" class="accordion-collapse collapse show"
                                    aria-labelledby="headingUnassigned">
                                    <div class="accordion-body p-0">
                                        <ul class="list-group list-group-flush sortable" data-floor-id="0">
                                            <?php $__currentLoopData = $stages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php echo $__env->make('construction.stages.section_stage_row', ['stage' => $stage, 'settings' => $settings], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="ti ti-building" style="font-size: 48px; opacity: 0.3;"></i>
                        <p class="text-muted mt-3"><?php echo e(__('No construction stages found.')); ?></p>
                        <p class="text-muted">
                            <?php echo e(__('Click "Create Stage" button above to add your first construction stage.')); ?>

                        </p>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/construction/resources/views/construction/stages/index.blade.php ENDPATH**/ ?>