<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Petty Cash Management')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Petty Cash')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('action-btn'); ?>
    <div class="float-end">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create expense')): ?>
            <a href="<?php echo e(route('petty-cash.create')); ?>" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="<?php echo e(__('Create Allocation')); ?>">
                <i class="ti ti-plus"></i>
            </a>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table datatable">
                            <thead>
                            <tr>
                                <th><?php echo e(__('Employee')); ?></th>
                                <th><?php echo e(__('Purpose')); ?></th>
                                <th><?php echo e(__('Allocated Amount')); ?></th>
                                <th><?php echo e(__('Current Balance')); ?></th>
                                <th><?php echo e(__('Status')); ?></th>
                                <th><?php echo e(__('Allocation Date')); ?></th>
                                <th width="10%"><?php echo e(__('Action')); ?></th>
                            </tr>
                            </thead>
                            <tbody>
                            <?php $__currentLoopData = $allocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $allocation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($allocation->employee->name ?? 'N/A'); ?></td>
                                    <td><?php echo e($allocation->purpose); ?></td>
                                    <td><?php echo e(\Auth::user()->priceFormat($allocation->allocated_amount)); ?></td>
                                    <td>
                                        <span class="badge <?php echo e($allocation->current_balance > 0 ? 'bg-success' : 'bg-warning'); ?>">
                                            <?php echo e(\Auth::user()->priceFormat($allocation->current_balance)); ?>

                                        </span>
                                    </td>
                                    <td>
                                        <?php if($allocation->status == 'active'): ?>
                                            <span class="badge bg-success"><?php echo e(__('Active')); ?></span>
                                        <?php elseif($allocation->status == 'inactive'): ?>
                                            <span class="badge bg-secondary"><?php echo e(__('Inactive')); ?></span>
                                        <?php else: ?>
                                            <span class="badge bg-danger"><?php echo e(__('Expired')); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td><?php echo e(\Auth::user()->dateFormat($allocation->allocation_date)); ?></td>
                                    <td class="Action">
                                        <span>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('show expense')): ?>
                                                <div class="action-btn bg-warning ms-2">
                                                    <a href="<?php echo e(route('petty-cash.show', $allocation->id)); ?>" class="mx-3 btn btn-sm align-items-center" data-bs-toggle="tooltip" title="<?php echo e(__('Show')); ?>" data-original-title="<?php echo e(__('Detail')); ?>">
                                                        <i class="ti ti-eye text-white"></i>
                                                    </a>
                                                </div>
                                            <?php endif; ?>
                                            
                                            <?php if($allocation->current_balance > 0): ?>
                                                <div class="action-btn bg-info ms-2">
                                                    <a href="#" class="mx-3 btn btn-sm align-items-center" data-bs-toggle="modal" data-bs-target="#returnCashModal<?php echo e($allocation->id); ?>" title="<?php echo e(__('Return Cash')); ?>">
                                                        <i class="ti ti-arrow-back-up text-white"></i>
                                                    </a>
                                                </div>
                                            <?php endif; ?>

                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete expense')): ?>
                                                <?php if($allocation->transactions->count() == 0): ?>
                                                    <div class="action-btn bg-danger ms-2">
                                                        <?php echo Form::open(['method' => 'DELETE', 'route' => ['petty-cash.destroy', $allocation->id], 'id' => 'delete-form-' . $allocation->id]); ?>

                                                        <a href="#" class="mx-3 btn btn-sm align-items-center bs-pass-para" data-bs-toggle="tooltip" title="<?php echo e(__('Delete')); ?>" data-original-title="<?php echo e(__('Delete')); ?>" data-confirm="<?php echo e(__('Are You Sure?')); ?>" data-text="<?php echo e(__('This action can not be undone. Do you want to continue?')); ?>" data-confirm-yes="delete-form-<?php echo e($allocation->id); ?>">
                                                            <i class="ti ti-trash text-white text-white"></i>
                                                        </a>
                                                        <?php echo Form::close(); ?>

                                                    </div>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                        </span>
                                    </td>
                                </tr>

                                <!-- Return Cash Modal -->
                                <div class="modal fade" id="returnCashModal<?php echo e($allocation->id); ?>" tabindex="-1" aria-labelledby="returnCashModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title"><?php echo e(__('Return Petty Cash')); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <?php echo Form::open(['route' => ['petty-cash.return', $allocation->id], 'method' => 'POST']); ?>

                                            <div class="modal-body">
                                                <div class="form-group">
                                                    <?php echo e(Form::label('return_amount',__('Return Amount'),['class'=>'form-label'])); ?>

                                                    <?php echo e(Form::number('return_amount', null, array('class' => 'form-control', 'step' => '0.01', 'max' => $allocation->current_balance, 'required' => 'required'))); ?>

                                                    <small class="text-muted"><?php echo e(__('Available Balance')); ?>: <?php echo e(\Auth::user()->priceFormat($allocation->current_balance)); ?></small>
                                                </div>
                                                <div class="form-group">
                                                    <?php echo e(Form::label('description',__('Description'),['class'=>'form-label'])); ?>

                                                    <?php echo e(Form::textarea('description', null, array('class' => 'form-control', 'rows' => 3))); ?>

                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                                <button type="submit" class="btn btn-primary"><?php echo e(__('Return Cash')); ?></button>
                                            </div>
                                            <?php echo Form::close(); ?>

                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/construction/resources/views/petty_cash/index.blade.php ENDPATH**/ ?>