<?php echo e(Form::open(['route' => ['construction.activities.store', $stage->id], 'method' => 'post'])); ?>

<div class="modal-body">
    <div class="row">
        <div class="form-group col-md-12">
            <?php echo e(Form::label('name', __('Activity Name'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('name', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => __('e.g., Concrete Pouring')])); ?>

        </div>

        <div class="form-group col-md-12">
            <?php echo e(Form::label('description', __('Description'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::textarea('description', null, ['class' => 'form-control', 'rows' => 2, 'placeholder' => __('Describe this activity...')])); ?>

        </div>

        <div class="form-group col-md-6">
            <?php echo e(Form::label('estimated_cost', __('Estimated Cost (Optional)'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::number('estimated_cost', null, ['class' => 'form-control', 'step' => '0.01', 'min' => '0', 'placeholder' => '0.00'])); ?>

            <small class="text-muted"><?php echo e(__('Can be added later')); ?></small>
        </div>

        <div class="form-group col-md-6">
            <?php echo e(Form::label('actual_cost', __('Actual Cost (Optional)'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::number('actual_cost', null, ['class' => 'form-control', 'step' => '0.01', 'min' => '0', 'placeholder' => '0.00'])); ?>

            <small class="text-muted"><?php echo e(__('Updated as expenses occur')); ?></small>
        </div>

        <div class="form-group col-md-4">
            <?php echo e(Form::label('labor_hours', __('Labor Hours (Optional)'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::number('labor_hours', null, ['class' => 'form-control', 'step' => '0.5', 'min' => '0', 'placeholder' => '0'])); ?>

        </div>

        <div class="form-group col-md-4">
            <?php echo e(Form::label('material_cost', __('Material Cost (Optional)'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::number('material_cost', null, ['class' => 'form-control', 'step' => '0.01', 'min' => '0', 'placeholder' => '0.00'])); ?>

        </div>

        <div class="form-group col-md-4">
            <?php echo e(Form::label('equipment_cost', __('Equipment Cost (Optional)'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::number('equipment_cost', null, ['class' => 'form-control', 'step' => '0.01', 'min' => '0', 'placeholder' => '0.00'])); ?>

        </div>

        <div class="form-group col-md-6">
            <?php echo e(Form::label('status', __('Status'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::select('status', \App\Models\ConstructionActivity::$statuses, 'pending', ['class' => 'form-control select'])); ?>

        </div>

        <div class="form-group col-md-6">
            <?php echo e(Form::label('progress_percentage', __('Progress %'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::number('progress_percentage', 0, ['class' => 'form-control', 'min' => '0', 'max' => '100', 'placeholder' => '0'])); ?>

        </div>

        <div class="form-group col-md-12">
            <?php echo e(Form::label('assigned_to', __('Assign To'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::select('assigned_to[]', $users, null, ['class' => 'form-control select2', 'multiple' => 'multiple'])); ?>

        </div>

        <div class="form-group col-md-6">
            <?php echo e(Form::label('start_date', __('Start Date'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::date('start_date', null, ['class' => 'form-control'])); ?>

        </div>

        <div class="form-group col-md-6">
            <?php echo e(Form::label('end_date', __('End Date'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::date('end_date', null, ['class' => 'form-control'])); ?>

        </div>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-light" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
    <button type="submit" class="btn btn-primary"><?php echo e(__('Create')); ?></button>
</div>
<?php echo e(Form::close()); ?>

<?php /**PATH /Applications/MAMP/htdocs/construction/resources/views/construction/activities/create.blade.php ENDPATH**/ ?>