<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Create Petty Cash Allocation')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('petty-cash.index')); ?>"><?php echo e(__('Petty Cash')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Create')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form method="post" action="<?php echo e(route('petty-cash.store')); ?>">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?php echo e(Form::label('employee_id',__('Employee'),['class'=>'form-label'])); ?>

                                    <select class="form-control select2" name="employee_id" id="employee_id" required>
                                        <option value=""><?php echo e(__('Select Employee')); ?></option>
                                        <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($employee->id); ?>" <?php echo e(old('employee_id') == $employee->id ? 'selected' : ''); ?>>
                                                <?php echo e($employee->name); ?>

                                            </option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?php echo e(Form::label('allocated_amount',__('Allocated Amount'),['class'=>'form-label'])); ?>

                                    <?php echo e(Form::number('allocated_amount', old('allocated_amount'), array('class' => 'form-control', 'step' => '0.01', 'min' => '1', 'required' => 'required'))); ?>

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <?php echo e(Form::label('purpose',__('Purpose'),['class'=>'form-label'])); ?>

                                    <?php echo e(Form::text('purpose', old('purpose'), array('class' => 'form-control', 'required' => 'required', 'placeholder' => __('Enter purpose for this allocation')))); ?>

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?php echo e(Form::label('allocation_date',__('Allocation Date'),['class'=>'form-label'])); ?>

                                    <?php echo e(Form::date('allocation_date', old('allocation_date', date('Y-m-d')), array('class' => 'form-control', 'required' => 'required'))); ?>

                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group">
                                    <input type="submit" value="<?php echo e(__('Create')); ?>" class="btn btn-print-invoice btn-primary m-r-10">
                                    <a href="<?php echo e(route('petty-cash.index')); ?>" class="btn btn-secondary"><?php echo e(__('Cancel')); ?></a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/construction/resources/views/petty_cash/create.blade.php ENDPATH**/ ?>