<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Gantt Chart')); ?> - <?php echo e($project->project_name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('projects.index')); ?>"><?php echo e(__('Projects')); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('projects.show', $project->id)); ?>"><?php echo e($project->project_name); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Gantt Chart')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('action-btn'); ?>
    <div class="float-end">
        <a href="<?php echo e(route('construction.stages.index', $project->id)); ?>" class="btn btn-sm btn-secondary">
            <i class="ti ti-arrow-left"></i> <?php echo e(__('Back to Stages')); ?>

        </a>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css-page'); ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/frappe-gantt@0.6.1/dist/frappe-gantt.min.css">
    <style>
        .gantt-container {
            overflow-x: auto;
            background: white;
            padding: 20px;
            border-radius: 5px;
        }
        .gantt .bar {
            fill: #6c757d;
        }
        .gantt .bar-progress {
            fill: #0d6efd;
        }
        .gantt-activity-pending .bar {
            fill: #6c757d;
        }
        .gantt-activity-in_progress .bar {
            fill: #0d6efd;
        }
        .gantt-activity-in_progress .bar-progress {
            fill: #0b5ed7;
        }
        .gantt-activity-completed .bar {
            fill: #198754;
        }
        .gantt-activity-completed .bar-progress {
            fill: #157347;
        }
        .gantt-activity-rework .bar {
            fill: #dc3545;
        }
        .gantt-activity-rework .bar-progress {
            fill: #b02a37;
        }
        .gantt .bar-label {
            fill: #fff;
            font-weight: 500;
        }
        .gantt-legend {
            display: flex;
            gap: 20px;
            margin-bottom: 20px;
            padding: 15px;
            background: white;
            border-radius: 5px;
        }
        .gantt-legend-item {
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .gantt-legend-color {
            width: 20px;
            height: 20px;
            border-radius: 3px;
        }
        .filter-section {
            background: white;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .filter-section .form-check {
            display: inline-block;
            margin-right: 20px;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5><?php echo e(__('Project Timeline Overview')); ?></h5>
                </div>
                <div class="card-body">
                    <div class="gantt-legend">
                        <div class="gantt-legend-item">
                            <div class="gantt-legend-color" style="background: #6c757d;"></div>
                            <span><?php echo e(__('Pending')); ?></span>
                        </div>
                        <div class="gantt-legend-item">
                            <div class="gantt-legend-color" style="background: #0d6efd;"></div>
                            <span><?php echo e(__('In Progress')); ?></span>
                        </div>
                        <div class="gantt-legend-item">
                            <div class="gantt-legend-color" style="background: #198754;"></div>
                            <span><?php echo e(__('Completed')); ?></span>
                        </div>
                        <div class="gantt-legend-item">
                            <div class="gantt-legend-color" style="background: #dc3545;"></div>
                            <span><?php echo e(__('Rework Required')); ?></span>
                        </div>
                    </div>

                    <div class="filter-section">
                        <h6><?php echo e(__('Filter by Status')); ?></h6>
                        <div class="form-check">
                            <input class="form-check-input status-filter" type="checkbox" value="pending" id="filter-pending" checked>
                            <label class="form-check-label" for="filter-pending"><?php echo e(__('Pending')); ?></label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input status-filter" type="checkbox" value="in_progress" id="filter-in_progress" checked>
                            <label class="form-check-label" for="filter-in_progress"><?php echo e(__('In Progress')); ?></label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input status-filter" type="checkbox" value="completed" id="filter-completed" checked>
                            <label class="form-check-label" for="filter-completed"><?php echo e(__('Completed')); ?></label>
                        </div>
                        <div class="form-check">
                            <input class="form-check-input status-filter" type="checkbox" value="rework" id="filter-rework" checked>
                            <label class="form-check-label" for="filter-rework"><?php echo e(__('Rework Required')); ?></label>
                        </div>
                    </div>

                    <?php if(count($ganttData) > 0): ?>
                        <div class="gantt-container">
                            <svg id="gantt"></svg>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="ti ti-calendar-time" style="font-size: 48px; opacity: 0.3;"></i>
                            <p class="text-muted mt-3"><?php echo e(__('No activities with dates found.')); ?></p>
                            <p class="text-muted"><?php echo e(__('Add start and end dates to activities to view them in the Gantt chart.')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5><?php echo e(__('Activity Details')); ?></h5>
                </div>
                <div class="card-body table-border-style">
                    <?php if(count($ganttData) > 0): ?>
                        <div class="table-responsive">
                            <table class="table" id="activity-table">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Activity')); ?></th>
                                        <th><?php echo e(__('Stage')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Progress')); ?></th>
                                        <th><?php echo e(__('Start Date')); ?></th>
                                        <th><?php echo e(__('End Date')); ?></th>
                                        <th><?php echo e(__('Duration')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $ganttData; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr data-status="<?php echo e($item['status']); ?>">
                                            <td><?php echo e($item['name']); ?></td>
                                            <td><?php echo e($item['stage']); ?></td>
                                            <td>
                                                <span class="badge badge-<?php echo e(\App\Models\ConstructionActivity::$status_colors[$item['status']] ?? 'secondary'); ?>">
                                                    <?php echo e(\App\Models\ConstructionActivity::$statuses[$item['status']] ?? 'Unknown'); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <div class="progress" style="height: 8px;">
                                                    <div class="progress-bar bg-success" role="progressbar"
                                                         style="width: <?php echo e($item['progress']); ?>%"></div>
                                                </div>
                                                <small><?php echo e($item['progress']); ?>%</small>
                                            </td>
                                            <td><?php echo e(\Carbon\Carbon::parse($item['start'])->format('d M Y')); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($item['end'])->format('d M Y')); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($item['start'])->diffInDays(\Carbon\Carbon::parse($item['end']))); ?> <?php echo e(__('days')); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script-page'); ?>
    <script src="https://cdn.jsdelivr.net/npm/frappe-gantt@0.6.1/dist/frappe-gantt.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            <?php if(count($ganttData) > 0): ?>
                let allTasks = <?php echo json_encode($ganttData, 15, 512) ?>;
                let ganttInstance = null;

                function renderGantt(tasks) {
                    if (tasks.length === 0) {
                        document.getElementById('gantt').innerHTML = '<text x="50%" y="50" text-anchor="middle" fill="#999">No activities match the selected filters</text>';
                        return;
                    }

                    if (ganttInstance) {
                        ganttInstance.refresh(tasks);
                    } else {
                        ganttInstance = new Gantt("#gantt", tasks, {
                            view_mode: 'Day',
                            bar_height: 30,
                            bar_corner_radius: 3,
                            arrow_curve: 5,
                            padding: 18,
                            view_modes: ['Quarter Day', 'Half Day', 'Day', 'Week', 'Month'],
                            date_format: 'YYYY-MM-DD',
                            popup_trigger: 'click',
                            custom_popup_html: function(task) {
                                const start_date = new Date(task._start);
                                const end_date = new Date(task._end);
                                const duration = Math.ceil((end_date - start_date) / (1000 * 60 * 60 * 24));

                                return `
                                    <div class="details-container">
                                        <h5>${task.name}</h5>
                                        <p><strong>Stage:</strong> ${task.stage}</p>
                                        <p><strong>Status:</strong> ${task.status.replace('_', ' ').toUpperCase()}</p>
                                        <p><strong>Progress:</strong> ${task.progress}%</p>
                                        <p><strong>Duration:</strong> ${duration} days</p>
                                        <p><strong>Start:</strong> ${start_date.toLocaleDateString()}</p>
                                        <p><strong>End:</strong> ${end_date.toLocaleDateString()}</p>
                                    </div>
                                `;
                            },
                            on_view_change: function(mode) {
                                console.log('View mode changed to:', mode);
                            }
                        });
                    }
                }

                // Initial render
                renderGantt(allTasks);

                // Filter functionality
                const statusFilters = document.querySelectorAll('.status-filter');
                statusFilters.forEach(filter => {
                    filter.addEventListener('change', function() {
                        const activeFilters = Array.from(statusFilters)
                            .filter(f => f.checked)
                            .map(f => f.value);

                        const filteredTasks = allTasks.filter(task =>
                            activeFilters.includes(task.status)
                        );

                        renderGantt(filteredTasks);

                        // Filter table rows
                        const tableRows = document.querySelectorAll('#activity-table tbody tr');
                        tableRows.forEach(row => {
                            const status = row.getAttribute('data-status');
                            if (activeFilters.includes(status)) {
                                row.style.display = '';
                            } else {
                                row.style.display = 'none';
                            }
                        });
                    });
                });

                // View mode switcher
                const viewButtons = `
                    <div class="btn-group mb-3" role="group">
                        <button type="button" class="btn btn-sm btn-outline-primary view-mode-btn" data-mode="Quarter Day">Quarter Day</button>
                        <button type="button" class="btn btn-sm btn-outline-primary view-mode-btn" data-mode="Half Day">Half Day</button>
                        <button type="button" class="btn btn-sm btn-outline-primary view-mode-btn active" data-mode="Day">Day</button>
                        <button type="button" class="btn btn-sm btn-outline-primary view-mode-btn" data-mode="Week">Week</button>
                        <button type="button" class="btn btn-sm btn-outline-primary view-mode-btn" data-mode="Month">Month</button>
                    </div>
                `;
                document.querySelector('.gantt-container').insertAdjacentHTML('beforebegin', viewButtons);

                document.querySelectorAll('.view-mode-btn').forEach(btn => {
                    btn.addEventListener('click', function() {
                        document.querySelectorAll('.view-mode-btn').forEach(b => b.classList.remove('active'));
                        this.classList.add('active');
                        ganttInstance.change_view_mode(this.getAttribute('data-mode'));
                    });
                });
            <?php endif; ?>
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/construction/resources/views/construction/gantt.blade.php ENDPATH**/ ?>