<?php ($settings = \App\Models\Utility::settings()); ?>

<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Construction Activities')); ?> - <?php echo e($stage->name); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('projects.index')); ?>"><?php echo e(__('Projects')); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('projects.show', $project->id)); ?>"><?php echo e($project->project_name); ?></a></li>
    <li class="breadcrumb-item"><a href="<?php echo e(route('construction.stages.index', $project->id)); ?>"><?php echo e(__('Stages')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e($stage->name); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('action-btn'); ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create project')): ?>
        <div class="float-end">
            <a href="<?php echo e(route('construction.stages.index', $project->id)); ?>" class="btn btn-sm btn-secondary">
                <i class="ti ti-arrow-left"></i> <?php echo e(__('Back to Stages')); ?>

            </a>
            <a href="<?php echo e(route('construction.gantt', $project->id)); ?>" class="btn btn-sm btn-info">
                <i class="ti ti-calendar-time"></i> <?php echo e(__('Gantt Chart')); ?>

            </a>
            <a href="#" data-url="<?php echo e(route('construction.activities.create', $stage->id)); ?>"
               data-ajax-popup="true"
               data-title="<?php echo e(__('Create Construction Activity')); ?>"
               data-size="lg"
               class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i> <?php echo e(__('Create Activity')); ?>

            </a>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5><?php echo e(__('Stage Overview')); ?>: <?php echo e($stage->name); ?></h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="text-center">
                                <h6 class="text-muted"><?php echo e(__('Budget Allocated')); ?></h6>
                                <h4 class="text-primary">
                                    <?php if($stage->hasBudget()): ?>
                                        <?php echo e(\App\Models\Utility::priceFormat($settings, $stage->budget_allocated)); ?>

                                    <?php else: ?>
                                        <span class="text-muted"><?php echo e(__('Not Set')); ?></span>
                                    <?php endif; ?>
                                </h4>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h6 class="text-muted"><?php echo e(__('Budget Spent')); ?></h6>
                                <h4 class="<?php echo e($stage->isOverBudget() ? 'text-danger' : 'text-success'); ?>">
                                    <?php echo e(\App\Models\Utility::priceFormat($settings, $stage->getBudgetSpent())); ?>

                                </h4>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h6 class="text-muted"><?php echo e(__('Budget Remaining')); ?></h6>
                                <h4 class="text-info">
                                    <?php if($stage->hasBudget()): ?>
                                        <?php echo e(\App\Models\Utility::priceFormat($settings, $stage->getBudgetRemaining())); ?>

                                    <?php else: ?>
                                        <span class="text-muted"><?php echo e(__('N/A')); ?></span>
                                    <?php endif; ?>
                                </h4>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h6 class="text-muted"><?php echo e(__('Progress')); ?></h6>
                                <h4 class="text-success"><?php echo e($stage->getProgressPercentage()); ?>%</h4>
                            </div>
                        </div>
                    </div>
                    <?php if($stage->description): ?>
                        <div class="row mt-3">
                            <div class="col-12">
                                <p class="text-muted mb-0"><strong><?php echo e(__('Description')); ?>:</strong></p>
                                <p><?php echo e($stage->description); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5><?php echo e(__('Construction Activities')); ?></h5>
                </div>
                <div class="card-body table-border-style">
                    <?php if($activities->count() > 0): ?>
                        <div class="table-responsive">
                            <table class="table datatable">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Activity Name')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Progress')); ?></th>
                                        <th><?php echo e(__('Estimated Cost')); ?></th>
                                        <th><?php echo e(__('Actual Cost')); ?></th>
                                        <th><?php echo e(__('Variance')); ?></th>
                                        <th><?php echo e(__('Assigned To')); ?></th>
                                        <th><?php echo e(__('Duration')); ?></th>
                                        <th><?php echo e(__('Action')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($activity->name); ?></td>
                                            <td>
                                                <span class="badge badge-<?php echo e($activity->getStatusBadgeColor()); ?>">
                                                    <?php echo e($activity->getStatusLabel()); ?>

                                                </span>
                                            </td>
                                            <td>
                                                <div class="progress" style="height: 8px;">
                                                    <div class="progress-bar bg-success" role="progressbar"
                                                         style="width: <?php echo e($activity->progress_percentage); ?>%"></div>
                                                </div>
                                                <small><?php echo e($activity->progress_percentage); ?>%</small>
                                            </td>
                                            <td>
                                                <?php if($activity->hasEstimate()): ?>
                                                    <?php echo e(\App\Models\Utility::priceFormat($settings, $activity->estimated_cost)); ?>

                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="<?php echo e($activity->isOverBudget() ? 'text-danger' : ''); ?>">
                                                <?php if($activity->actual_cost): ?>
                                                    <?php echo e(\App\Models\Utility::priceFormat($settings, $activity->actual_cost)); ?>

                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td class="<?php echo e($activity->getCostVariance() && $activity->getCostVariance() < 0 ? 'text-danger' : 'text-success'); ?>">
                                                <?php if($activity->getCostVariance()): ?>
                                                    <?php echo e(\App\Models\Utility::priceFormat($settings, $activity->getCostVariance())); ?>

                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($activity->assignedUsers()->count() > 0): ?>
                                                    <div class="avatar-group">
                                                        <?php $__currentLoopData = $activity->assignedUsers()->take(3); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <a href="#" class="avatar rounded-circle avatar-sm"
                                                               data-bs-toggle="tooltip" title="<?php echo e($user->name); ?>">
                                                                <img alt="<?php echo e($user->name); ?>" src="<?php echo e($user->getImgImageAttribute()); ?>">
                                                            </a>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php if($activity->assignedUsers()->count() > 3): ?>
                                                            <a href="#" class="avatar rounded-circle avatar-sm">
                                                                <span>+<?php echo e($activity->assignedUsers()->count() - 3); ?></span>
                                                            </a>
                                                        <?php endif; ?>
                                                    </div>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($activity->start_date && $activity->end_date): ?>
                                                    <?php echo e($activity->start_date->format('d M')); ?> - <?php echo e($activity->end_date->format('d M')); ?>

                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit project')): ?>
                                                    <div class="action-btn bg-primary ms-2">
                                                        <a href="#" data-url="<?php echo e(route('construction.activities.edit', $activity->id)); ?>"
                                                           data-ajax-popup="true"
                                                           data-title="<?php echo e(__('Edit Activity')); ?>"
                                                           data-size="lg"
                                                           class="mx-3 btn btn-sm d-inline-flex align-items-center"
                                                           data-bs-toggle="tooltip"
                                                           title="<?php echo e(__('Edit')); ?>">
                                                            <i class="ti ti-pencil text-white"></i>
                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete project')): ?>
                                                    <div class="action-btn bg-danger ms-2">
                                                        <?php echo Form::open(['method' => 'DELETE', 'route' => ['construction.activities.destroy', $activity->id], 'class' => 'd-inline']); ?>

                                                        <a href="#"
                                                           class="mx-3 btn btn-sm d-inline-flex align-items-center bs-pass-para"
                                                           data-bs-toggle="tooltip"
                                                           title="<?php echo e(__('Delete')); ?>">
                                                            <i class="ti ti-trash text-white"></i>
                                                        </a>
                                                        <?php echo Form::close(); ?>

                                                    </div>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <div class="text-center py-5">
                            <i class="ti ti-checklist" style="font-size: 48px; opacity: 0.3;"></i>
                            <p class="text-muted mt-3"><?php echo e(__('No construction activities found for this stage.')); ?></p>
                            <p class="text-muted"><?php echo e(__('Click "Create Activity" button above to add your first activity.')); ?></p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/construction/resources/views/construction/activities/index.blade.php ENDPATH**/ ?>