<li class="list-group-item" data-id="<?php echo e($stage->id); ?>">
    <div class="row align-items-center">
        <div class="col-auto">
            <span class="sort-handle" style="cursor: move;">
                <i class="ti ti-grip-vertical"></i>
            </span>
        </div>
        <div class="col-3">
            <h6 class="mb-0"><?php echo e($stage->name); ?></h6>
            <small class="text-muted">
                <span class="badge badge-<?php echo e($stage::$status_colors[$stage->status] ?? 'secondary'); ?>">
                    <?php echo e($stage::$statuses[$stage->status] ?? __('Unknown')); ?>

                </span>
            </small>
        </div>
        <div class="col-2">
            <small class="text-muted"><?php echo e(__('Budget')); ?></small>
            <div>
                <?php if($stage->hasBudget()): ?>
                    <?php echo e(Utility::priceFormat($settings, $stage->budget_allocated)); ?>

                <?php else: ?>
                    <span class="text-muted">-</span>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-2">
            <small class="text-muted"><?php echo e(__('Spent')); ?></small>
            <div class="<?php echo e($stage->isOverBudget() ? 'text-danger' : ''); ?>">
                <?php echo e(Utility::priceFormat($settings, $stage->getBudgetSpent())); ?>

            </div>
        </div>
        <div class="col-2">
            <small class="text-muted"><?php echo e(__('Progress')); ?></small>
            <div class="progress mt-1" style="height: 8px;">
                <div class="progress-bar bg-success" role="progressbar"
                    style="width: <?php echo e($stage->getProgressPercentage()); ?>%"></div>
            </div>
            <small><?php echo e($stage->getProgressPercentage()); ?>%</small>
        </div>
        <div class="col-1">
            <small class="text-muted"><?php echo e(__('Duration')); ?></small>
            <div>
                <?php if($stage->start_date && $stage->end_date): ?>
                    <?php echo e($stage->start_date->format('d M')); ?> - <?php echo e($stage->end_date->format('d M')); ?>

                <?php else: ?>
                    <span class="text-muted">-</span>
                <?php endif; ?>
            </div>
        </div>
        <div class="col-2 text-end">
            <div class="d-flex justify-content-end align-items-center gap-2 flex-nowrap">
                <div class="action-btn bg-info">
                    <a href="<?php echo e(route('construction.activities.index', $stage->id)); ?>"
                        class="btn btn-sm d-inline-flex align-items-center" data-bs-toggle="tooltip"
                        title="<?php echo e(__('View Activities')); ?>">
                        <i class="ti ti-list text-white"></i>
                    </a>
                </div>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit project')): ?>
                    <div class="action-btn bg-primary">
                        <a href="#" data-url="<?php echo e(route('construction.stages.edit', $stage->id)); ?>" data-ajax-popup="true"
                            data-title="<?php echo e(__('Edit Construction Stage')); ?>" data-size="lg"
                            class="btn btn-sm d-inline-flex align-items-center" data-bs-toggle="tooltip"
                            title="<?php echo e(__('Edit')); ?>">
                            <i class="ti ti-pencil text-white"></i>
                        </a>
                    </div>
                <?php endif; ?>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete project')): ?>
                    <div class="action-btn bg-danger">
                        <?php echo Form::open(['method' => 'DELETE', 'route' => ['construction.stages.destroy', $stage->id], 'class' => 'd-inline']); ?>

                        <a href="#" class="btn btn-sm d-inline-flex align-items-center bs-pass-para"
                            data-bs-toggle="tooltip" title="<?php echo e(__('Delete')); ?>">
                            <i class="ti ti-trash text-white"></i>
                        </a>
                        <?php echo Form::close(); ?>

                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</li><?php /**PATH /Applications/MAMP/htdocs/construction/resources/views/construction/stages/section_stage_row.blade.php ENDPATH**/ ?>