<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Construction Tasks Library')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a></li>
    <li class="breadcrumb-item"><?php echo e(__('Construction Tasks')); ?></li>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('action-btn'); ?>
    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('create project')): ?>
        <div class="float-end">
            <a href="#" data-url="<?php echo e(route('construction-tasks.create')); ?>" data-ajax-popup="true"
                data-title="<?php echo e(__('Create New Task')); ?>" data-size="md" class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i> <?php echo e(__('Create Task')); ?>

            </a>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Name')); ?></th>
                                    <th><?php echo e(__('Code')); ?></th>
                                    <th><?php echo e(__('Status')); ?></th>
                                    <th><?php echo e(__('Description')); ?></th>
                                    <th><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $tasks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $task): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($task->name); ?></td>
                                        <td><?php echo e($task->code ?? '-'); ?></td>
                                        <td>
                                            <?php if($task->is_active): ?>
                                                <span class="badge bg-success"><?php echo e(__('Active')); ?></span>
                                            <?php else: ?>
                                                <span class="badge bg-danger"><?php echo e(__('Inactive')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e(\Illuminate\Support\Str::limit($task->description, 30)); ?></td>
                                        <td class="Action">
                                            <div class="d-flex justify-content-start gap-2">
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('edit project')): ?>
                                                    <div class="action-btn bg-primary">
                                                        <a href="#" data-url="<?php echo e(route('construction-tasks.edit', $task->id)); ?>"
                                                            data-ajax-popup="true" data-title="<?php echo e(__('Edit Task')); ?>" data-size="md"
                                                            class="btn btn-sm d-inline-flex align-items-center"
                                                            data-bs-toggle="tooltip" title="<?php echo e(__('Edit')); ?>">
                                                            <i class="ti ti-pencil text-white"></i>
                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete project')): ?>
                                                    <div class="action-btn bg-danger">
                                                        <?php echo Form::open(['method' => 'DELETE', 'route' => ['construction-tasks.destroy', $task->id], 'class' => 'd-inline']); ?>

                                                        <a href="#" class="btn btn-sm d-inline-flex align-items-center bs-pass-para"
                                                            data-bs-toggle="tooltip" title="<?php echo e(__('Delete')); ?>">
                                                            <i class="ti ti-trash text-white"></i>
                                                        </a>
                                                        <?php echo Form::close(); ?>

                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/construction/resources/views/construction/tasks/index.blade.php ENDPATH**/ ?>