@extends('layouts.admin')

@section('page-title')
    {{ __('Construction Floors') }} - {{ $project->project_name }}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
    <li class="breadcrumb-item"><a href="{{ route('projects.index') }}">{{ __('Projects') }}</a></li>
    <li class="breadcrumb-item"><a href="{{ route('projects.show', $project->id) }}">{{ $project->project_name }}</a></li>
    <li class="breadcrumb-item">{{ __('Construction Floors') }}</li>
@endsection

@section('action-btn')
    @can('create project')
        <div class="float-end">
            <a href="#" data-url="{{ route('construction.floors.create', $project->id) }}" data-ajax-popup="true"
                data-title="{{ __('Create Construction Floor') }}" data-size="md" class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i> {{ __('Create Floor') }}
            </a>
        </div>
    @endcan
@endsection

@push('script-page')
    <script src="{{ asset('assets/js/jquery-ui.min.js') }}"></script>
    <script>
        $(function () {
            $(".sortable").sortable({
                handle: '.sort-handle',
                stop: function () {
                    var order = [];
                    $(this).find('li').each(function (index, data) {
                        order[index] = $(data).attr('data-id');
                    });
                    $.ajax({
                        url: "{{ route('construction.floors.order', $project->id) }}",
                        data: { order: order, _token: '{{ csrf_token() }}' },
                        type: 'POST',
                        success: function (data) {
                            show_toastr('{{ __("Success") }}', '{{ __("Order updated successfully") }}', 'success');
                        },
                        error: function (data) {
                            show_toastr('{{ __("Error") }}', '{{ __("Something went wrong") }}', 'error');
                        }
                    });
                }
            });
        });
    </script>
@endpush

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5>{{ __('Construction Floors') }}</h5>
                    <small class="text-muted">{{ __('Drag and drop to reorder floors') }}</small>
                </div>
                <div class="card-body">
                    @if($floors->count() > 0)
                        <ul class="list-group sortable">
                            @foreach ($floors as $floor)
                                <li class="list-group-item" data-id="{{ $floor->id }}">
                                    <div class="row align-items-center">
                                        <div class="col-auto">
                                            <span class="sort-handle" style="cursor: move;">
                                                <i class="ti ti-grip-vertical"></i>
                                            </span>
                                        </div>
                                        <div class="col">
                                            <h6 class="mb-0">{{ $floor->name }}</h6>
                                            @if($floor->description)
                                                <small class="text-muted">{{ $floor->description }}</small>
                                            @endif
                                        </div>
                                        <div class="col-auto">
                                            <h6 class="mb-0">{{ $floor->stages->count() }}</h6>
                                            <small class="text-muted">{{ __('Stages') }}</small>
                                        </div>
                                        <div class="col-auto text-end">
                                            <div class="d-flex justify-content-end align-items-center gap-2 flex-nowrap">
                                                @can('edit project')
                                                    <div class="action-btn bg-primary">
                                                        <a href="#" data-url="{{ route('construction.floors.edit', $floor->id) }}"
                                                            data-ajax-popup="true" data-title="{{ __('Edit Construction Floor') }}"
                                                            data-size="md" class="btn btn-sm d-inline-flex align-items-center"
                                                            data-bs-toggle="tooltip" title="{{ __('Edit') }}">
                                                            <i class="ti ti-pencil text-white"></i>
                                                        </a>
                                                    </div>
                                                @endcan
                                                @can('delete project')
                                                    <div class="action-btn bg-danger">
                                                        {!! Form::open(['method' => 'DELETE', 'route' => ['construction.floors.destroy', $floor->id], 'class' => 'd-inline']) !!}
                                                        <a href="#" class="btn btn-sm d-inline-flex align-items-center bs-pass-para"
                                                            data-bs-toggle="tooltip" title="{{ __('Delete') }}">
                                                            <i class="ti ti-trash text-white"></i>
                                                        </a>
                                                        {!! Form::close() !!}
                                                    </div>
                                                @endcan
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            @endforeach
                        </ul>
                    @else
                        <div class="text-center py-5">
                            <i class="ti ti-layers-union" style="font-size: 48px; opacity: 0.3;"></i>
                            <p class="text-muted mt-3">{{ __('No construction floors found.') }}</p>
                            <p class="text-muted">{{ __('Click "Create Floor" button above to add your first floor.') }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection