@extends('layouts.admin')
@section('page-title')
    {{__('Petty Cash Allocation Details')}}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item"><a href="{{route('petty-cash.index')}}">{{__('Petty Cash')}}</a></li>
    <li class="breadcrumb-item">{{__('Details')}}</li>
@endsection

@section('action-btn')
    <div class="float-end">
        @if($allocation->current_balance > 0)
            <a href="#" class="btn btn-sm btn-info" data-bs-toggle="modal" data-bs-target="#returnCashModal" title="{{__('Return Cash')}}">
                <i class="ti ti-arrow-back-up"></i> {{__('Return Cash')}}
            </a>
        @endif
        <a href="{{ route('petty-cash.index') }}" class="btn btn-sm btn-secondary">
            <i class="ti ti-arrow-left"></i> {{__('Back')}}
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <!-- Allocation Summary -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5>{{__('Allocation Summary')}}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-12">
                            <div class="info-item">
                                <strong>{{__('Employee')}}:</strong>
                                <span>{{ $allocation->employee->name ?? 'N/A' }}</span>
                            </div>
                        </div>
                        <div class="col-12 mt-2">
                            <div class="info-item">
                                <strong>{{__('Purpose')}}:</strong>
                                <span>{{ $allocation->purpose }}</span>
                            </div>
                        </div>
                        <div class="col-12 mt-2">
                            <div class="info-item">
                                <strong>{{__('Allocated Amount')}}:</strong>
                                <span class="text-success">{{ \Auth::user()->priceFormat($allocation->allocated_amount) }}</span>
                            </div>
                        </div>
                        <div class="col-12 mt-2">
                            <div class="info-item">
                                <strong>{{__('Current Balance')}}:</strong>
                                <span class="badge {{ $allocation->current_balance > 0 ? 'bg-success' : 'bg-warning' }}">
                                    {{ \Auth::user()->priceFormat($allocation->current_balance) }}
                                </span>
                            </div>
                        </div>
                        <div class="col-12 mt-2">
                            <div class="info-item">
                                <strong>{{__('Status')}}:</strong>
                                @if($allocation->status == 'active')
                                    <span class="badge bg-success">{{__('Active')}}</span>
                                @elseif($allocation->status == 'inactive')
                                    <span class="badge bg-secondary">{{__('Inactive')}}</span>
                                @else
                                    <span class="badge bg-danger">{{__('Expired')}}</span>
                                @endif
                            </div>
                        </div>
                        <div class="col-12 mt-2">
                            <div class="info-item">
                                <strong>{{__('Allocation Date')}}:</strong>
                                <span>{{ \Auth::user()->dateFormat($allocation->allocation_date) }}</span>
                            </div>
                        </div>
                        <div class="col-12 mt-2">
                            <div class="info-item">
                                <strong>{{__('Allocated By')}}:</strong>
                                <span>{{ $allocation->allocatedBy->name ?? 'N/A' }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Transaction History -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">
                    <h5>{{__('Transaction History')}}</h5>
                </div>
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                            <tr>
                                <th>{{__('Date')}}</th>
                                <th>{{__('Type')}}</th>
                                <th>{{__('Description')}}</th>
                                <th>{{__('Amount')}}</th>
                                <th>{{__('Balance After')}}</th>
                                <th>{{__('Expense')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @forelse ($transactions as $transaction)
                                <tr>
                                    <td>{{ \Auth::user()->dateFormat($transaction->transaction_date) }}</td>
                                    <td>
                                        @if($transaction->transaction_type == 'allocation')
                                            <span class="badge bg-primary">{{__('Allocation')}}</span>
                                        @elseif($transaction->transaction_type == 'expense')
                                            <span class="badge bg-danger">{{__('Expense')}}</span>
                                        @else
                                            <span class="badge bg-info">{{__('Return')}}</span>
                                        @endif
                                    </td>
                                    <td>{{ $transaction->description }}</td>
                                    <td>
                                        @if($transaction->transaction_type == 'expense')
                                            <span class="text-danger">-{{ \Auth::user()->priceFormat($transaction->amount) }}</span>
                                        @elseif($transaction->transaction_type == 'return')
                                            <span class="text-info">-{{ \Auth::user()->priceFormat($transaction->amount) }}</span>
                                        @else
                                            <span class="text-success">+{{ \Auth::user()->priceFormat($transaction->amount) }}</span>
                                        @endif
                                    </td>
                                    <td>{{ \Auth::user()->priceFormat($transaction->balance_after) }}</td>
                                    <td>
                                        @if($transaction->expense)
                                            <a href="{{ route('expense.show', $transaction->expense->id) }}" class="btn btn-sm btn-outline-primary">
                                                {{__('View Expense')}}
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center">{{__('No transactions found')}}</td>
                                </tr>
                            @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Return Cash Modal -->
    @if($allocation->current_balance > 0)
        <div class="modal fade" id="returnCashModal" tabindex="-1" aria-labelledby="returnCashModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">{{__('Return Petty Cash')}}</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    {!! Form::open(['route' => ['petty-cash.return', $allocation->id], 'method' => 'POST']) !!}
                    <div class="modal-body">
                        <div class="form-group">
                            {{Form::label('return_amount',__('Return Amount'),['class'=>'form-label'])}}
                            {{Form::number('return_amount', null, array('class' => 'form-control', 'step' => '0.01', 'max' => $allocation->current_balance, 'required' => 'required'))}}
                            <small class="text-muted">{{__('Available Balance')}}: {{ \Auth::user()->priceFormat($allocation->current_balance) }}</small>
                        </div>
                        <div class="form-group">
                            {{Form::label('description',__('Description'),['class'=>'form-label'])}}
                            {{Form::textarea('description', null, array('class' => 'form-control', 'rows' => 3))}}
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__('Close')}}</button>
                        <button type="submit" class="btn btn-primary">{{__('Return Cash')}}</button>
                    </div>
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    @endif
@endsection

@push('script-page')
<style>
.info-item {
    margin-bottom: 10px;
}
.info-item strong {
    display: inline-block;
    width: 140px;
}
</style>
@endpush