@extends('layouts.admin')
@section('page-title')
    {{__('Petty Cash Management')}}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item">{{__('Petty Cash')}}</li>
@endsection

@section('action-btn')
    <div class="float-end">
        @can('create expense')
            <a href="{{ route('petty-cash.create') }}" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="{{__('Create Allocation')}}">
                <i class="ti ti-plus"></i>
            </a>
        @endcan
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table datatable">
                            <thead>
                            <tr>
                                <th>{{__('Employee')}}</th>
                                <th>{{__('Purpose')}}</th>
                                <th>{{__('Allocated Amount')}}</th>
                                <th>{{__('Current Balance')}}</th>
                                <th>{{__('Status')}}</th>
                                <th>{{__('Allocation Date')}}</th>
                                <th width="10%">{{__('Action')}}</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach ($allocations as $allocation)
                                <tr>
                                    <td>{{ $allocation->employee->name ?? 'N/A' }}</td>
                                    <td>{{ $allocation->purpose }}</td>
                                    <td>{{ \Auth::user()->priceFormat($allocation->allocated_amount) }}</td>
                                    <td>
                                        <span class="badge {{ $allocation->current_balance > 0 ? 'bg-success' : 'bg-warning' }}">
                                            {{ \Auth::user()->priceFormat($allocation->current_balance) }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($allocation->status == 'active')
                                            <span class="badge bg-success">{{__('Active')}}</span>
                                        @elseif($allocation->status == 'inactive')
                                            <span class="badge bg-secondary">{{__('Inactive')}}</span>
                                        @else
                                            <span class="badge bg-danger">{{__('Expired')}}</span>
                                        @endif
                                    </td>
                                    <td>{{ \Auth::user()->dateFormat($allocation->allocation_date) }}</td>
                                    <td class="Action">
                                        <span>
                                            @can('show expense')
                                                <div class="action-btn bg-warning ms-2">
                                                    <a href="{{ route('petty-cash.show', $allocation->id) }}" class="mx-3 btn btn-sm align-items-center" data-bs-toggle="tooltip" title="{{__('Show')}}" data-original-title="{{__('Detail')}}">
                                                        <i class="ti ti-eye text-white"></i>
                                                    </a>
                                                </div>
                                            @endcan
                                            
                                            @if($allocation->current_balance > 0)
                                                <div class="action-btn bg-info ms-2">
                                                    <a href="#" class="mx-3 btn btn-sm align-items-center" data-bs-toggle="modal" data-bs-target="#returnCashModal{{ $allocation->id }}" title="{{__('Return Cash')}}">
                                                        <i class="ti ti-arrow-back-up text-white"></i>
                                                    </a>
                                                </div>
                                            @endif

                                            @can('delete expense')
                                                @if($allocation->transactions->count() == 0)
                                                    <div class="action-btn bg-danger ms-2">
                                                        {!! Form::open(['method' => 'DELETE', 'route' => ['petty-cash.destroy', $allocation->id], 'id' => 'delete-form-' . $allocation->id]) !!}
                                                        <a href="#" class="mx-3 btn btn-sm align-items-center bs-pass-para" data-bs-toggle="tooltip" title="{{__('Delete')}}" data-original-title="{{__('Delete')}}" data-confirm="{{__('Are You Sure?')}}" data-text="{{__('This action can not be undone. Do you want to continue?')}}" data-confirm-yes="delete-form-{{$allocation->id}}">
                                                            <i class="ti ti-trash text-white text-white"></i>
                                                        </a>
                                                        {!! Form::close() !!}
                                                    </div>
                                                @endif
                                            @endcan
                                        </span>
                                    </td>
                                </tr>

                                <!-- Return Cash Modal -->
                                <div class="modal fade" id="returnCashModal{{ $allocation->id }}" tabindex="-1" aria-labelledby="returnCashModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title">{{__('Return Petty Cash')}}</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            {!! Form::open(['route' => ['petty-cash.return', $allocation->id], 'method' => 'POST']) !!}
                                            <div class="modal-body">
                                                <div class="form-group">
                                                    {{Form::label('return_amount',__('Return Amount'),['class'=>'form-label'])}}
                                                    {{Form::number('return_amount', null, array('class' => 'form-control', 'step' => '0.01', 'max' => $allocation->current_balance, 'required' => 'required'))}}
                                                    <small class="text-muted">{{__('Available Balance')}}: {{ \Auth::user()->priceFormat($allocation->current_balance) }}</small>
                                                </div>
                                                <div class="form-group">
                                                    {{Form::label('description',__('Description'),['class'=>'form-label'])}}
                                                    {{Form::textarea('description', null, array('class' => 'form-control', 'rows' => 3))}}
                                                </div>
                                            </div>
                                            <div class="modal-footer">
                                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__('Close')}}</button>
                                                <button type="submit" class="btn btn-primary">{{__('Return Cash')}}</button>
                                            </div>
                                            {!! Form::close() !!}
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection