@extends('layouts.admin')
@section('page-title')
    {{__('Create Petty Cash Allocation')}}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item"><a href="{{route('petty-cash.index')}}">{{__('Petty Cash')}}</a></li>
    <li class="breadcrumb-item">{{__('Create')}}</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <form method="post" action="{{ route('petty-cash.store') }}">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{Form::label('employee_id',__('Employee'),['class'=>'form-label'])}}
                                    <select class="form-control select2" name="employee_id" id="employee_id" required>
                                        <option value="">{{__('Select Employee')}}</option>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ old('employee_id') == $employee->id ? 'selected' : '' }}>
                                                {{ $employee->name }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{Form::label('allocated_amount',__('Allocated Amount'),['class'=>'form-label'])}}
                                    {{Form::number('allocated_amount', old('allocated_amount'), array('class' => 'form-control', 'step' => '0.01', 'min' => '1', 'required' => 'required'))}}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    {{Form::label('purpose',__('Purpose'),['class'=>'form-label'])}}
                                    {{Form::text('purpose', old('purpose'), array('class' => 'form-control', 'required' => 'required', 'placeholder' => __('Enter purpose for this allocation')))}}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    {{Form::label('allocation_date',__('Allocation Date'),['class'=>'form-label'])}}
                                    {{Form::date('allocation_date', old('allocation_date', date('Y-m-d')), array('class' => 'form-control', 'required' => 'required'))}}
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <div class="form-group">
                                    <input type="submit" value="{{__('Create')}}" class="btn btn-print-invoice btn-primary m-r-10">
                                    <a href="{{ route('petty-cash.index') }}" class="btn btn-secondary">{{__('Cancel')}}</a>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection