@extends('layouts.admin')
@section('page-title')
    {{$lead->name}}
@endsection

@push('css-page')
    <link rel="stylesheet" href="{{asset('css/summernote/summernote-bs4.css')}}">
    <link rel="stylesheet" href="{{asset('assets/css/plugins/dropzone.min.css')}}">
@endpush
@push('script-page')
    <script src="{{asset('css/summernote/summernote-bs4.js')}}"></script>
    <script src="{{asset('assets/js/plugins/dropzone-amd-module.min.js')}}"></script>
    <script>
        var scrollSpy = new bootstrap.ScrollSpy(document.body, {
            target: '#lead-sidenav',
            offset: 300
        })
        Dropzone.autoDiscover = false;
        Dropzone.autoDiscover = false;
        myDropzone = new Dropzone("#dropzonewidget", {
            maxFiles: 20,
            // maxFilesize: 2000,
            parallelUploads: 1,
            filename: false,
            // acceptedFiles: ".jpeg,.jpg,.png,.pdf,.doc,.txt",
            url: "{{route('leads.file.upload', $lead->id)}}",
            success: function (file, response) {
                if (response.is_success) {
                    if (response.status == 1) {
                        show_toastr('success', response.success_msg, 'success');
                    }
                    dropzoneBtn(file, response);
                } else {
                    myDropzone.removeFile(file);
                    show_toastr('error', response.error, 'error');
                }
            },
            error: function (file, response) {
                myDropzone.removeFile(file);
                if (response.error) {
                    show_toastr('error', response.error, 'error');
                } else {
                    show_toastr('error', response, 'error');
                }
            }
        });
        myDropzone.on("sending", function (file, xhr, formData) {
            formData.append("_token", $('meta[name="csrf-token"]').attr('content'));
            formData.append("lead_id", {{$lead->id}});
        });

        function dropzoneBtn(file, response) {
            var download = document.createElement('a');
            download.setAttribute('href', response.download);
            download.setAttribute('class', "badge bg-info mx-1");
            download.setAttribute('data-toggle', "tooltip");
            download.setAttribute('data-original-title', "{{__('Download')}}");
            download.innerHTML = "<i class='ti ti-download'></i>";

            var del = document.createElement('a');
            del.setAttribute('href', response.delete);
            del.setAttribute('class', "badge bg-danger mx-1");
            del.setAttribute('data-toggle', "tooltip");
            del.setAttribute('data-original-title', "{{__('Delete')}}");
            del.innerHTML = "<i class='ti ti-trash'></i>";

            del.addEventListener("click", function (e) {
                e.preventDefault();
                e.stopPropagation();
                if (confirm("Are you sure ?")) {
                    var btn = $(this);
                    $.ajax({
                        url: btn.attr('href'),
                        data: { _token: $('meta[name="csrf-token"]').attr('content') },
                        type: 'DELETE',
                        success: function (response) {
                            if (response.is_success) {
                                btn.closest('.dz-image-preview').remove();
                            } else {
                                show_toastr('error', response.error, 'error');
                            }
                        },
                        error: function (response) {
                            response = response.responseJSON;
                            if (response.is_success) {
                                show_toastr('error', response.error, 'error');
                            } else {
                                show_toastr('error', response, 'error');
                            }
                        }
                    })
                }
            });

            var html = document.createElement('div');
            html.appendChild(download);
            @if(Auth::user()->type != 'client')
                @can('edit lead')
                    html.appendChild(del);
                @endcan
            @endif

            file.previewTemplate.appendChild(html);
        }

        @foreach($lead->files as $file)
            @if (file_exists(storage_path('lead_files/' . $file->file_path)))
                // Create the mock file:
                var mockFile = { name: "{{$file->file_name}}", size: {{\File::size(storage_path('lead_files/' . $file->file_path))}}};
                // Call the default addedfile event handler
                myDropzone.emit("addedfile", mockFile);
                // And optionally show the thumbnail of the file:
                myDropzone.emit("thumbnail", mockFile, "{{asset(Storage::url('lead_files/' . $file->file_path))}}");
                myDropzone.emit("complete", mockFile);

                dropzoneBtn(mockFile, { download: "{{route('leads.file.download', [$lead->id, $file->id])}}", delete: "{{route('leads.file.delete', [$lead->id, $file->id])}}" });
            @endif
        @endforeach

        @can('edit lead')
            $('.summernote-simple').on('summernote.blur', function () {

                $.ajax({
                    url: "{{route('leads.note.store', $lead->id)}}",
                    data: { _token: $('meta[name="csrf-token"]').attr('content'), notes: $(this).val() },
                    type: 'POST',
                    success: function (response) {
                        if (response.is_success) {
                            // show_toastr('Success', response.success,'success');
                        } else {
                            show_toastr('error', response.error, 'error');
                        }
                    },
                    error: function (response) {
                        response = response.responseJSON;
                        if (response.is_success) {
                            show_toastr('error', response.error, 'error');
                        } else {
                            show_toastr('error', response, 'error');
                        }
                    }
                })
            });
        @else
            $('.summernote-simple').summernote('disable');
        @endcan

    </script>

@endpush
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item"><a href="{{route('leads.index')}}">{{__('Lead')}}</a></li>
    <li class="breadcrumb-item"> {{$lead->name}}</li>
@endsection
@section('action-btn')
    <div class="float-end">
        @can('convert lead to deal')
            @if(!empty($deal))
                <a href="@can('View Deal') @if($deal->is_active) {{route('deals.show', $deal->id)}} @else # @endif @else # @endcan"
                    data-size="lg" data-bs-toggle="tooltip" title=" {{__('Already Converted To Deal')}}"
                    class="btn btn-sm btn-primary me-1">
                    <i class="ti ti-exchange"></i>
                </a>
            @else
                <a href="#" data-size="lg" data-url="{{ URL::to('leads/' . $lead->id . '/show_convert') }}" data-ajax-popup="true"
                    data-bs-toggle="tooltip" title="{{__('Convert [' . $lead->subject . '] To Deal')}}"
                    class="btn btn-sm btn-primary me-1">
                    <i class="ti ti-exchange"></i>
                </a>
            @endif
        @endcan

        <a href="#" data-url="{{ URL::to('leads/' . $lead->id . '/labels') }}" data-ajax-popup="true" data-size="lg"
            data-bs-toggle="tooltip" title="{{__('Label')}}" class="btn btn-sm btn-primary me-1">
            <i class="ti ti-bookmark"></i>
        </a>
        <a href="#" data-size="lg" data-url="{{ route('leads.edit', $lead->id) }}" data-ajax-popup="true"
            data-bs-toggle="tooltip" title="{{__('Edit')}}" class="btn btn-sm btn-primary me-1">
            <i class="ti ti-pencil"></i>
        </a>
    </div>
@endsection

@section('content')
    <div class="row">
        <div class="col-sm-12">
            <div class="row">
                <div class="col-xl-3">
                    <div class="card sticky-top" style="top:30px">
                        <div class="list-group list-group-flush" id="lead-sidenav">
                            @if(Auth::user()->type != 'client')
                                <a href="#general" class="list-group-item list-group-item-action border-0">{{__('General')}}
                                    <div class="float-end"><i class="ti ti-chevron-right"></i></div>
                                </a>
                            @endif

                            @if(Auth::user()->type != 'client')
                                <a href="#users_products"
                                    class="list-group-item list-group-item-action border-0">{{__('Users') . ' | ' . __('Products')}}
                                    <div class="float-end"><i class="ti ti-chevron-right"></i></div>
                                </a>
                            @endif

                            @if(Auth::user()->type != 'client')
                                <a href="#sources_emails"
                                    class="list-group-item list-group-item-action border-0">{{__('Sources') . ' | ' . __('Emails')}}
                                    <div class="float-end"><i class="ti ti-chevron-right"></i></div>
                                </a>
                            @endif
                            @if(Auth::user()->type != 'client')
                                <a href="#discussion_note"
                                    class="list-group-item list-group-item-action border-0">{{__('Discussion') . ' | ' . __('Notes')}}
                                    <div class="float-end"><i class="ti ti-chevron-right"></i></div>
                                </a>
                            @endif
                            @if(Auth::user()->type != 'client')
                                <a href="#files" class="list-group-item list-group-item-action border-0">{{__('Files')}}
                                    <div class="float-end"><i class="ti ti-chevron-right"></i></div>
                                </a>
                            @endif
                            @if(Auth::user()->type != 'client')
                                <a href="#calls" class="list-group-item list-group-item-action border-0">{{__('Calls')}}
                                    <div class="float-end"><i class="ti ti-chevron-right"></i></div>
                                </a>
                            @endif
                            @if(Auth::user()->type != 'client')
                                <a href="#activity" class="list-group-item list-group-item-action border-0">{{__('Activity')}}
                                    <div class="float-end"><i class="ti ti-chevron-right"></i></div>
                                </a>
                            @endif

                        </div>
                    </div>
                </div>
                <div class="col-xl-9">
                    <?php
    $products = $lead->products();
    $sources = $lead->sources();
    $calls = $lead->calls;
    $emails = $lead->emails;
                                    ?>
                    <div id="general" class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4 col-sm-4">
                                    <div class="d-flex align-items-start">
                                        <div class="theme-avtar bg-primary badge">
                                            <i class="ti ti-mail"></i>
                                        </div>
                                        <div class="ms-2">
                                            <p class="text-muted text-sm mb-0">{{__('Email')}}</p>
                                            <h5 class="mb-0 text-primary">{{!empty($lead->email) ? $lead->email : ''}}</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-4">
                                    <div class="d-flex align-items-start">
                                        <div class="theme-avtar bg-warning badge">
                                            <i class="ti ti-phone"></i>
                                        </div>
                                        <div class="ms-2">
                                            <p class="text-muted text-sm mb-0">{{__('Phone')}}</p>
                                            <h5 class="mb-0 text-warning">{{!empty($lead->phone) ? $lead->phone : ''}}</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-4">
                                    <div class="d-flex align-items-start">
                                        <div class="theme-avtar bg-info badge">
                                            <i class="ti ti-test-pipe"></i>
                                        </div>
                                        <div class="ms-2">
                                            <p class="text-muted text-sm mb-0">{{__('Pipeline')}}</p>
                                            <h5 class="mb-0 text-info">{{$lead->pipeline->name}}</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-4 mt-4">
                                    <div class="d-flex align-items-start">
                                        <div class="theme-avtar bg-primary badge">
                                            <i class="ti ti-server"></i>
                                        </div>
                                        <div class="ms-2">
                                            <p class="text-muted text-sm mb-0">{{__('Stage')}}</p>
                                            <h5 class="mb-0 text-primary">{{$lead->stage->name}}</h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-4 mt-4">
                                    <div class="d-flex align-items-start">
                                        <div class="theme-avtar bg-warning badge">
                                            <i class="ti ti-calendar"></i>
                                        </div>
                                        <div class="ms-2">
                                            <p class="text-muted text-sm mb-0">{{__('Created')}}</p>
                                            <h5 class="mb-0 text-warning">{{\Auth::user()->dateFormat($lead->created_at)}}
                                            </h5>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4 col-sm-4 mt-4">
                                    <div class="d-flex align-items-start">
                                        <div class="theme-avtar bg-info badge">
                                            <i class="ti ti-chart-bar"></i>
                                        </div>
                                        <div class="ms-2">
                                            <h3 class="mb-0 text-info">{{$precentage}}%</h3>
                                            <div class="progress mb-0">
                                                <div class="progress-bar bg-info" style="width: {{$precentage}}%;"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row align-items-center justify-content-between">
                                        <div class="col-auto mb-3 mb-sm-0">
                                            <small class="text-muted">{{__('Product')}}</small>
                                            <h3 class="m-0">{{count($products)}}</h3>
                                        </div>
                                        <div class="col-auto">
                                            <div class="theme-avtar bg-info badge">
                                                <i class="ti ti-shopping-cart"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row align-items-center justify-content-between">
                                        <div class="col-auto mb-3 mb-sm-0">
                                            <small class="text-muted">{{__('Source')}}</small>
                                            <h3 class="m-0">{{count($sources)}}</h3>
                                        </div>
                                        <div class="col-auto">
                                            <div class="theme-avtar bg-primary badge">
                                                <i class="ti ti-social"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-sm-4">
                            <div class="card">
                                <div class="card-body">
                                    <div class="row align-items-center justify-content-between">
                                        <div class="col-auto mb-3 mb-sm-0">
                                            <small class="text-muted">{{__('Files')}}</small>
                                            <h3 class="m-0">{{count($lead->files)}}</h3>
                                        </div>
                                        <div class="col-auto">
                                            <div class="theme-avtar bg-warning badge">
                                                <i class="ti ti-file"></i>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div id="cost_calculator" class="card">
                        <div class="card-header">
                            <div class="d-flex align-items-center justify-content-between">
                                <h5>{{__('Cost Calculator')}}</h5>
                                <div class="float-end">
                                    <button class="btn btn-sm btn-primary" id="btn-add-floor">
                                        <i class="ti ti-plus text-white"></i> {{__('Add Floor / Section')}}
                                    </button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="cost-calculator-container">
                                <!-- JS will populate this -->
                                <div class="text-center p-3"><i class="fas fa-spinner fa-spin"></i>
                                    {{__('Loading Calculator...')}}</div>
                            </div>
                            <div class="mt-3 text-end">
                                <h4>{{__('Total Estimate')}}: <span id="grand-total">0.00</span></h4>
                            </div>
                        </div>
                    </div>

                    <!-- Modal for Adding Item -->
                    <div class="modal fade" id="addItemModal" tabindex="-1" role="dialog" aria-hidden="true">
                        <div class="modal-dialog modal-lg" role="document">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{__('Add Estimation Item')}}</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"
                                        aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <form id="form-add-item">
                                        <input type="hidden" id="item-floor-name" name="floor_name">
                                        <div class="row">
                                            <div class="col-md-6 form-group">
                                                <label class="form-label">{{__('Task Name')}}</label>
                                                <input type="text" class="form-control" name="task_name" required
                                                    placeholder="e.g. Brick Work">
                                            </div>
                                            <div class="col-md-6 form-group">
                                                <label class="form-label">{{__('Material Spec')}}</label>
                                                <input type="text" class="form-control" name="material_spec"
                                                    placeholder="e.g. 1:6 Cement Mortar">
                                            </div>
                                            <div class="col-md-6 form-group">
                                                <label class="form-label">{{__('Brand')}}</label>
                                                <select class="form-control" name="brand_id" id="brand-select">
                                                    <option value="">{{__('Select Brand')}}</option>
                                                </select>
                                            </div>
                                            <div class="col-md-4 form-group">
                                                <label class="form-label">{{__('Unit')}}</label>
                                                <input type="text" class="form-control" name="unit" placeholder="e.g. sqft">
                                            </div>
                                            <div class="col-md-4 form-group">
                                                <label class="form-label">{{__('Quantity')}}</label>
                                                <input type="number" step="0.01" class="form-control cal-input"
                                                    name="quantity" required>
                                            </div>
                                            <div class="col-md-4 form-group">
                                                <label class="form-label">{{__('Rate')}}</label>
                                                <input type="number" step="0.01" class="form-control cal-input" name="rate"
                                                    required>
                                            </div>
                                            <div class="col-md-4 form-group">
                                                <label class="form-label">{{__('Amount')}}</label>
                                                <input type="text" class="form-control" name="amount" readonly>
                                            </div>
                                        </div>
                                        <div class="text-end">
                                            <button type="button" class="btn btn-secondary"
                                                data-bs-dismiss="modal">{{__('Cancel')}}</button>
                                            <button type="submit" class="btn btn-primary">{{__('Save')}}</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="sources_emails">
                        <div class="row">
                            <div class="col-6">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <h5>{{__('Sources')}}</h5>
                                            <div class="float-end">
                                                <a data-size="md" data-url="{{ route('leads.sources.edit', $lead->id) }}"
                                                    data-ajax-popup="true" data-bs-toggle="tooltip"
                                                    title="{{__('Add Source')}}" class="btn btn-sm btn-primary">
                                                    <i class="ti ti-plus text-white"></i>
                                                </a>
                                            </div>
                                        </div>

                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-hover mb-0">
                                                <thead>
                                                    <tr>
                                                        <th>{{__('Name')}}</th>
                                                        <th>{{__('Action')}}</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($sources as $source)
                                                        <tr>
                                                            <td>{{$source->name}} </td>
                                                            @can('edit lead')
                                                                <td>
                                                                    <div class="action-btn me-2">
                                                                        {!! Form::open(['method' => 'DELETE', 'route' => ['leads.sources.destroy', $lead->id, $source->id], 'id' => 'delete-form-' . $lead->id]) !!}
                                                                        <a href="#"
                                                                            class="mx-3 btn btn-sm  align-items-center bs-pass-para bg-danger"
                                                                            data-bs-toggle="tooltip" title="{{__('Delete')}}"><i
                                                                                class="ti ti-trash text-white"></i></a>

                                                                        {!! Form::close() !!}
                                                                    </div>
                                                                </td>
                                                            @endcan
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <h5>{{__('Emails')}}</h5>
                                            @can('create lead email')
                                                <div class="float-end">
                                                    <a data-size="md" data-url="{{ route('leads.emails.create', $lead->id) }}"
                                                        data-ajax-popup="true" data-bs-toggle="tooltip"
                                                        title="{{__('Create Email')}}" class="btn btn-sm btn-primary">
                                                        <i class="ti ti-plus text-white"></i>
                                                    </a>
                                                </div>
                                            @endcan
                                        </div>

                                    </div>
                                    <div class="card-body">
                                        <div class="list-group list-group-flush mt-2">
                                            @if(!$emails->isEmpty())
                                                @foreach($emails as $email)
                                                    <li class="list-group-item px-0">
                                                        <div class="d-block d-sm-flex align-items-start">
                                                            <img src="{{asset('/storage/uploads/avatar/avatar.png')}}"
                                                                class="rounded border-2 border border-primary wid-40 me-3 mb-2 mb-sm-0"
                                                                alt="image">
                                                            <div class="w-100">
                                                                <div class="d-flex align-items-center justify-content-between">
                                                                    <div class="mb-3 mb-sm-0">
                                                                        <h6 class="mb-0">{{$email->subject}}</h6>
                                                                        <span class="text-muted text-sm">{{$email->to}}</span>
                                                                    </div>
                                                                    <div class="form-check form-switch form-switch-right mb-2">
                                                                        {{$email->created_at->diffForHumans()}}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                @endforeach
                                            @else
                                                <li class="text-center">
                                                    {{__(' No Emails Available.!')}}
                                                </li>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="discussion_note">
                        <div class="row">
                            <div class="col-6">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <h5>{{__('Discussion')}}</h5>
                                            <div class="float-end">
                                                <a data-size="lg"
                                                    data-url="{{ route('leads.discussions.create', $lead->id) }}"
                                                    data-ajax-popup="true" data-bs-toggle="tooltip"
                                                    title="{{__('Add Message')}}" class="btn btn-sm btn-primary">
                                                    <i class="ti ti-plus text-white"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        <ul class="list-group list-group-flush mt-2">
                                            @if(!$lead->discussions->isEmpty())
                                                @foreach($lead->discussions as $discussion)
                                                    <li class="list-group-item px-0">
                                                        <div class="d-block d-sm-flex align-items-start">
                                                            <img src="@if($discussion->user->avatar) {{asset('/storage/uploads/avatar/' . $discussion->user->avatar)}} @else {{asset('/storage/uploads/avatar/avatar.png')}} @endif"
                                                                class="rounded border-2 border border-primary wid-40 me-3 mb-2 mb-sm-0"
                                                                alt="image">
                                                            <div class="w-100">
                                                                <div class="d-flex align-items-center justify-content-between">
                                                                    <div class="mb-3 mb-sm-0">
                                                                        <h6 class="mb-0"> {{$discussion->comment}}</h6>
                                                                        <span
                                                                            class="text-muted text-sm">{{$discussion->user->name}}</span>
                                                                    </div>
                                                                    <div class="form-check form-switch form-switch-right mb-2">
                                                                        {{$discussion->created_at->diffForHumans()}}
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </li>
                                                @endforeach
                                            @else
                                                <li class="text-center">
                                                    {{__(' No Data Available.!')}}
                                                </li>
                                            @endif
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="col-6">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <h5>{{__('Notes')}}</h5>
                                            @php
                                                $user = \App\Models\User::find(\Auth::user()->creatorId());
                                                $plan = \App\Models\Plan::getPlan($user->plan);
                                            @endphp
                                            @if($plan->chatgpt == 1)
                                                <div class="float-end">
                                                    <a href="#" data-size="md" class="btn btn-primary btn-icon btn-sm"
                                                        data-ajax-popup-over="true" id="grammarCheck"
                                                        data-url="{{ route('grammar', ['grammar']) }}" data-bs-placement="top"
                                                        data-title="{{ __('Grammar check with AI') }}">
                                                        <i class="ti ti-rotate"></i>
                                                        <span>{{__('Grammar check with AI')}}</span>
                                                    </a>
                                                    <a href="#" data-size="md" class="btn  btn-primary btn-icon btn-sm"
                                                        data-ajax-popup-over="true" data-url="{{ route('generate', ['lead']) }}"
                                                        data-bs-placement="top"
                                                        data-title="{{ __('Generate content with AI') }}">
                                                        <i class="fas fa-robot"></i> <span>{{__('Generate with AI')}}</span>
                                                    </a>
                                                </div>
                                            @endif
                                        </div>
                                    </div>

                                    <div class="card-body">
                                        <textarea class="summernote-simple " name="note">{!! $lead->notes !!}</textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div id="files" class="card">
                        <div class="card-header ">
                            <h5>{{__('Files')}}</h5>
                        </div>
                        <div class="card-body">
                            <div class="col-md-12 dropzone top-5-scroll browse-file" id="dropzonewidget"></div>
                        </div>
                    </div>
                    <div id="calls" class="card">
                        <div class="card-header">
                            <div class="d-flex align-items-center justify-content-between">
                                <h5>{{__('Calls')}}</h5>

                                <div class="float-end">
                                    <a data-size="lg" data-url="{{ route('leads.calls.create', $lead->id) }}"
                                        data-ajax-popup="true" data-bs-toggle="tooltip" title="{{__('Add Call')}}"
                                        class="btn btn-sm btn-primary">
                                        <i class="ti ti-plus text-white"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover mb-0">
                                    <thead>
                                        <tr>
                                            <th width="">{{__('Subject')}}</th>
                                            <th>{{__('Call Type')}}</th>
                                            <th>{{__('Duration')}}</th>
                                            <th>{{__('User')}}</th>
                                            <th>{{__('Action')}}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($calls as $call)
                                            <tr>
                                                <td>{{ $call->subject }}</td>
                                                <td>{{ ucfirst($call->call_type) }}</td>
                                                <td>{{ $call->duration }}</td>
                                                <td>{{ isset($call->getLeadCallUser) ? $call->getLeadCallUser->name : '-' }}
                                                </td>
                                                <td>
                                                    @can('edit lead call')
                                                        <div class="action-btn me-2">
                                                            <a href="#" class="mx-3 btn btn-sm align-items-center bg-info"
                                                                data-url="{{ URL::to('leads/' . $lead->id . '/call/' . $call->id . '/edit') }}"
                                                                data-ajax-popup="true" data-size="xl" data-bs-toggle="tooltip"
                                                                title="{{__('Edit')}}" data-title="{{__('Edit Call')}}">
                                                                <i class="ti ti-pencil text-white"></i>
                                                            </a>
                                                        </div>
                                                    @endcan
                                                    @can('delete lead call')
                                                        <div class="action-btn me-2">
                                                            {!! Form::open(['method' => 'DELETE', 'route' => ['leads.calls.destroy', $lead->id, $call->id], 'id' => 'delete-form-' . $lead->id]) !!}
                                                            <a href="#"
                                                                class="mx-3 btn btn-sm  align-items-center bs-pass-para bg-danger"
                                                                data-bs-toggle="tooltip" title="{{__('Delete')}}"><i
                                                                    class="ti ti-trash text-white"></i></a>

                                                            {!! Form::close() !!}
                                                        </div>
                                                    @endcan
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <div id="activity" class="card">
                        <div class="card-header">
                            <h5>{{__('Activity')}}</h5>
                        </div>
                        <div class="card-body ">

                            <div class="row leads-scroll">
                                <ul class="event-cards list-group list-group-flush mt-3 w-100">
                                    @if(!$lead->activities->isEmpty())
                                        @foreach($lead->activities as $activity)
                                            <li class="list-group-item card mb-3">
                                                <div class="row align-items-center justify-content-between">
                                                    <div class="col-auto mb-3 mb-sm-0">
                                                        <div class="d-flex align-items-center">
                                                            <div class="theme-avtar bg-primary badge">
                                                                <i class="ti {{ $activity->logIcon() }}"></i>
                                                            </div>
                                                            <div class="ms-3">
                                                                <span class="text-dark text-sm">{{ __($activity->log_type) }}</span>
                                                                <h6 class="m-0">{!! $activity->getLeadRemark() !!}</h6>
                                                                <small
                                                                    class="text-muted">{{$activity->created_at->diffForHumans()}}</small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-auto">

                                                    </div>
                                                </div>
                                            </li>
                                        @endforeach
                                    @else
                                        No activity found yet.
                                    @endif
                                </ul>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
    @push('script-page')
        <script>
            $(document).ready(function () {
                const leadId = {{$lead->id}};
                const quotationUrl = "{{route('leads.quotation.get', $lead->id)}}";
                const addItemUrl = "{{route('leads.quotation.items.store', $lead->id)}}";

                // SETUP CSRF TOKEN
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });

                // Load Data
                loadQuotationData();

                function loadQuotationData() {
                    // Ensure helper message is set while loading
                    $('#cost-calculator-container').html('<div class="text-center p-3"><i class="fas fa-spinner fa-spin"></i> {{__('Loading Calculator...')}}</div>');

                    $.get(quotationUrl, function (data) {
                        renderQuotation(data);
                    }).fail(function (jqXHR) {
                        $('#cost-calculator-container').html('<div class="text-center text-danger">{{__('Error loading calculator.')}}</div>');
                        console.error("Calculator Load Error:", jqXHR.responseText);
                    });
                }

                function renderQuotation(data) {
                    const container = $('#cost-calculator-container');
                    container.empty();

                    const itemsByFloor = {};

                    // Group items by floor
                    if (data.items) {
                        data.items.forEach(item => {
                            if (!itemsByFloor[item.floor_name]) {
                                itemsByFloor[item.floor_name] = [];
                            }
                            itemsByFloor[item.floor_name].push(item);
                        });
                    }

                    // Populate Brand Select
                    const brandSelect = $('#brand-select');
                    if (data.brands) {
                        brandSelect.find('option:not(:first)').remove();
                        data.brands.forEach(brand => {
                            brandSelect.append(new Option(brand.name, brand.id));
                        });
                    }

                    // Render Accordion
                    if (Object.keys(itemsByFloor).length === 0) {
                        container.html('<div class="text-center text-muted m-5"><h4>{{__('No items added yet.')}}</h4><p>{{__('Click "Add Floor / Section" above to start estimating your project.')}}</p></div>');
                    } else {
                        Object.keys(itemsByFloor).forEach((floor, index) => {
                            const floorId = floor.replace(/\s+/g, '-').toLowerCase();
                            let html = `
                                    <div class="accordion-item card mb-3">
                                        <h2 class="accordion-header" id="heading-${floorId}">
                                            <button class="accordion-button ${index > 0 ? 'collapsed' : ''}" type="button" data-bs-toggle="collapse" data-bs-target="#collapse-${floorId}" aria-expanded="${index === 0}" aria-controls="collapse-${floorId}">
                                                ${floor}
                                            </button>
                                        </h2>
                                        <div id="collapse-${floorId}" class="accordion-collapse collapse ${index === 0 ? 'show' : ''}" aria-labelledby="heading-${floorId}" data-bs-parent="#cost-calculator-container">
                                            <div class="card-body">
                                                <div class="text-end mb-2">
                                                    <button class="btn btn-sm btn-info btn-add-item" data-floor="${floor}"><i class="ti ti-plus"></i> {{__('Add Item')}}</button>
                                                </div>
                                                <div class="table-responsive">
                                                    <table class="table table-bordered table-sm">
                                                        <thead>
                                                            <tr>
                                                                <th>{{__('Task')}}</th>
                                                                <th>{{__('Material Spec')}}</th>
                                                                <th>{{__('Brand')}}</th>
                                                                <th>{{__('Unit')}}</th>
                                                                <th>{{__('Qty')}}</th>
                                                                <th>{{__('Rate')}}</th>
                                                                <th>{{__('Amount')}}</th>
                                                                <th>{{__('Action')}}</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                        ${itemsByFloor[floor].map(item => `
                                                            <tr>
                                                                <td>${item.task_name}</td>
                                                                <td>${item.material_spec || '-'}</td>
                                                                <td>${item.brand ? item.brand.name : '-'}</td>
                                                                <td>${item.unit || '-'}</td>
                                                                <td>${item.quantity}</td>
                                                                <td>${item.rate}</td>
                                                                <td>${item.amount}</td>
                                                                <td>
                                                                        <a href="#" class="btn btn-sm btn-danger btn-delete-item" data-id="${item.id}"><i class="ti ti-trash"></i></a>
                                                                </td>
                                                            </tr>
                                                        `).join('')}
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    `;
                            container.append((html));
                        });
                    }

                    if (data.quotation) {
                        $('#grand-total').text(parseFloat(data.quotation.total_amount).toFixed(2));
                    }
                }

                // Add Floor
                $('#btn-add-floor').click(function () {
                    const floorName = prompt("{{__('Enter Floor / Section Name (e.g. Ground Floor, Foundation):')}}");
                    if (floorName) {
                        $('#item-floor-name').val(floorName);
                        $('#addItemModal').modal('show');
                    }
                });

                // Add Item Button (Delegation)
                $(document).on('click', '.btn-add-item', function () {
                    const floor = $(this).data('floor');
                    $('#item-floor-name').val(floor);
                    $('#addItemModal').modal('show');
                });

                // Calculate Amount
                $('.cal-input').on('input', function () {
                    const qty = parseFloat($('input[name="quantity"]').val()) || 0;
                    const rate = parseFloat($('input[name="rate"]').val()) || 0;
                    $('input[name="amount"]').val((qty * rate).toFixed(2));
                });

                // Save Item
                $('#form-add-item').submit(function (e) {
                    e.preventDefault();
                    // Basic Validation
                    if (!$('input[name="task_name"]').val()) {
                        show_toastr('error', "{{__('Task Name is required')}}", 'error');
                        return;
                    }

                    const formData = $(this).serialize();
                    $.post(addItemUrl, formData, function (response) {
                        $('#addItemModal').modal('hide');
                        $('#form-add-item')[0].reset();
                        loadQuotationData();
                        show_toastr('success', "{{__('Item added successfully')}}", 'success');
                    }).fail(function (response) {
                        show_toastr('error', response.responseJSON ? response.responseJSON.error : 'Something went wrong', 'error');
                    });
                });

                // Delete Item
                $(document).on('click', '.btn-delete-item', function (e) {
                    e.preventDefault();
                    if (!confirm("{{__('Are you sure?')}}")) return;
                    const id = $(this).data('id');
                    // Construct URL correctly based on resource
                    // Since we used resource route manually in group:
                    const url = "{{url('leads')}}/" + leadId + "/quotation/items/" + id;

                    $.ajax({
                        url: url,
                        type: 'DELETE',
                        success: function (Result) {
                            loadQuotationData();
                            show_toastr('success', "{{__('Item deleted successfully')}}", 'success');
                        },
                        error: function (Result) {
                            show_toastr('error', 'Something went wrong', 'error');
                        }
                    });
                });
            });
        </script>
    @endpush
@endsection