@extends('layouts.admin')

@section('page-title')
    {{ __('Expense Categories') }}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
    <li class="breadcrumb-item">{{ __('Expense Categories') }}</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5>{{ __('Add Expense Category') }}</h5>
            </div>
            <div class="card-body">
                {{ Form::open(['route' => 'expense-categories.store', 'method' => 'post']) }}
                <div class="form-group">
                    {{ Form::label('name', __('Name'), ['class' => 'form-label']) }}
                    {{ Form::text('name', null, ['class' => 'form-control', 'required' => true]) }}
                </div>

                <div class="form-group">
                    {{ Form::label('chart_account_id', __('Chart of Account (optional)'), ['class' => 'form-label']) }}
                    {{ Form::select('chart_account_id', $chartAccounts, null, ['class' => 'form-control']) }}
                    <small class="form-text text-muted">{{ __('Map to an expense account for Bill posting.') }}</small>
                </div>

                <div class="form-group">
                    {{ Form::label('description', __('Description'), ['class' => 'form-label']) }}
                    {{ Form::textarea('description', null, ['class' => 'form-control', 'rows' => 2]) }}
                </div>

                <div class="text-end">
                    <button type="submit" class="btn btn-primary">{{ __('Create') }}</button>
                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>

    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5>{{ __('Existing Categories') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>{{ __('Name') }}</th>
                                <th>{{ __('Account') }}</th>
                                <th class="text-end">{{ __('Actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($categories as $cat)
                                <tr>
                                    <td>{{ $cat->name }}</td>
                                    <td>{{ optional($cat->chartAccount)->code }} - {{ optional($cat->chartAccount)->name }}</td>
                                    <td class="text-end">
                                        {{ Form::open(['route' => ['expense-categories.destroy', $cat->id], 'method' => 'delete']) }}
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('{{ __('Delete this category?') }}');">{{ __('Delete') }}</button>
                                        {{ Form::close() }}
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="3" class="text-center text-muted">{{ __('No categories yet.') }}</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection