@extends('layouts.admin')

@section('page-title')
    {{ __('Construction Tasks Library') }}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
    <li class="breadcrumb-item">{{ __('Construction Tasks') }}</li>
@endsection

@section('action-btn')
    @can('create project')
        <div class="float-end">
            <a href="#" data-url="{{ route('construction-tasks.create') }}" data-ajax-popup="true"
                data-title="{{ __('Create New Task') }}" data-size="md" class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i> {{ __('Create Task') }}
            </a>
        </div>
    @endcan
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table datatable">
                            <thead>
                                <tr>
                                    <th>{{ __('Name') }}</th>
                                    <th>{{ __('Code') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Description') }}</th>
                                    <th>{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($tasks as $task)
                                    <tr>
                                        <td>{{ $task->name }}</td>
                                        <td>{{ $task->code ?? '-' }}</td>
                                        <td>
                                            @if($task->is_active)
                                                <span class="badge bg-success">{{ __('Active') }}</span>
                                            @else
                                                <span class="badge bg-danger">{{ __('Inactive') }}</span>
                                            @endif
                                        </td>
                                        <td>{{ \Illuminate\Support\Str::limit($task->description, 30) }}</td>
                                        <td class="Action">
                                            <div class="d-flex justify-content-start gap-2">
                                                @can('edit project')
                                                    <div class="action-btn bg-primary">
                                                        <a href="#" data-url="{{ route('construction-tasks.edit', $task->id) }}"
                                                            data-ajax-popup="true" data-title="{{ __('Edit Task') }}" data-size="md"
                                                            class="btn btn-sm d-inline-flex align-items-center"
                                                            data-bs-toggle="tooltip" title="{{ __('Edit') }}">
                                                            <i class="ti ti-pencil text-white"></i>
                                                        </a>
                                                    </div>
                                                @endcan
                                                @can('delete project')
                                                    <div class="action-btn bg-danger">
                                                        {!! Form::open(['method' => 'DELETE', 'route' => ['construction-tasks.destroy', $task->id], 'class' => 'd-inline']) !!}
                                                        <a href="#" class="btn btn-sm d-inline-flex align-items-center bs-pass-para"
                                                            data-bs-toggle="tooltip" title="{{ __('Delete') }}">
                                                            <i class="ti ti-trash text-white"></i>
                                                        </a>
                                                        {!! Form::close() !!}
                                                    </div>
                                                @endcan
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection