<li class="list-group-item" data-id="{{ $stage->id }}">
    <div class="row align-items-center">
        <div class="col-auto">
            <span class="sort-handle" style="cursor: move;">
                <i class="ti ti-grip-vertical"></i>
            </span>
        </div>
        <div class="col-3">
            <h6 class="mb-0">{{ $stage->name }}</h6>
            <small class="text-muted">
                <span class="badge badge-{{ $stage::$status_colors[$stage->status] ?? 'secondary' }}">
                    {{ $stage::$statuses[$stage->status] ?? __('Unknown') }}
                </span>
            </small>
        </div>
        <div class="col-2">
            <small class="text-muted">{{ __('Budget') }}</small>
            <div>
                @if($stage->hasBudget())
                    {{ Utility::priceFormat($settings, $stage->budget_allocated) }}
                @else
                    <span class="text-muted">-</span>
                @endif
            </div>
        </div>
        <div class="col-2">
            <small class="text-muted">{{ __('Spent') }}</small>
            <div class="{{ $stage->isOverBudget() ? 'text-danger' : '' }}">
                {{ Utility::priceFormat($settings, $stage->getBudgetSpent()) }}
            </div>
        </div>
        <div class="col-2">
            <small class="text-muted">{{ __('Progress') }}</small>
            <div class="progress mt-1" style="height: 8px;">
                <div class="progress-bar bg-success" role="progressbar"
                    style="width: {{ $stage->getProgressPercentage() }}%"></div>
            </div>
            <small>{{ $stage->getProgressPercentage() }}%</small>
        </div>
        <div class="col-1">
            <small class="text-muted">{{ __('Duration') }}</small>
            <div>
                @if($stage->start_date && $stage->end_date)
                    {{ $stage->start_date->format('d M') }} - {{ $stage->end_date->format('d M') }}
                @else
                    <span class="text-muted">-</span>
                @endif
            </div>
        </div>
        <div class="col-2 text-end">
            <div class="d-flex justify-content-end align-items-center gap-2 flex-nowrap">
                <div class="action-btn bg-info">
                    <a href="{{ route('construction.activities.index', $stage->id) }}"
                        class="btn btn-sm d-inline-flex align-items-center" data-bs-toggle="tooltip"
                        title="{{ __('View Activities') }}">
                        <i class="ti ti-list text-white"></i>
                    </a>
                </div>
                @can('edit project')
                    <div class="action-btn bg-primary">
                        <a href="#" data-url="{{ route('construction.stages.edit', $stage->id) }}" data-ajax-popup="true"
                            data-title="{{ __('Edit Construction Stage') }}" data-size="lg"
                            class="btn btn-sm d-inline-flex align-items-center" data-bs-toggle="tooltip"
                            title="{{ __('Edit') }}">
                            <i class="ti ti-pencil text-white"></i>
                        </a>
                    </div>
                @endcan
                @can('delete project')
                    <div class="action-btn bg-danger">
                        {!! Form::open(['method' => 'DELETE', 'route' => ['construction.stages.destroy', $stage->id], 'class' => 'd-inline']) !!}
                        <a href="#" class="btn btn-sm d-inline-flex align-items-center bs-pass-para"
                            data-bs-toggle="tooltip" title="{{ __('Delete') }}">
                            <i class="ti ti-trash text-white"></i>
                        </a>
                        {!! Form::close() !!}
                    </div>
                @endcan
            </div>
        </div>
    </div>
</li>