{{ Form::open(['route' => ['construction.stages.import', $project->id], 'method' => 'post']) }}
<div class="modal-body">
    <div class="row">
        <div class="col-md-12 form-group">
            {{ Form::label('construction_floor_id', __('Select Floor'), ['class' => 'form-label']) }}
            {{ Form::select('construction_floor_id', $floors, null, ['class' => 'form-control', 'required' => 'required']) }}
        </div>
        <div class="col-md-12 form-group">
            {{ Form::label('tasks', __('Select Standard Tasks'), ['class' => 'form-label']) }}
            <div class="table-responsive" style="max-height: 300px; overflow-y: auto;">
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <th width="50"><input type="checkbox" id="select_all_tasks"></th>
                            <th>{{ __('Task Name') }}</th>
                            <th>{{ __('Description') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($tasks as $task)
                            <tr>
                                <td>{{ Form::checkbox('tasks[]', $task->id, false, ['class' => 'form-check-input task-checkbox']) }}
                                </td>
                                <td>{{ $task->name }}</td>
                                <td>{{ $task->description }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<div class="modal-footer">
    <input type="button" value="{{ __('Cancel') }}" class="btn  btn-light" data-bs-dismiss="modal">
    <input type="submit" value="{{ __('Import Selected') }}" class="btn  btn-primary">
</div>
{{ Form::close() }}

<script>
    document.getElementById('select_all_tasks').addEventListener('change', function () {
        var checkboxes = document.querySelectorAll('.task-checkbox');
        for (var i = 0; i < checkboxes.length; i++) {
            checkboxes[i].checked = this.checked;
        }
    });
</script>