@extends('layouts.admin')

@section('page-title')
    {{ __('Construction Stages') }} - {{ $project->project_name }}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
    <li class="breadcrumb-item"><a href="{{ route('projects.index') }}">{{ __('Projects') }}</a></li>
    <li class="breadcrumb-item"><a href="{{ route('projects.show', $project->id) }}">{{ $project->project_name }}</a></li>
    <li class="breadcrumb-item">{{ __('Construction Stages') }}</li>
@endsection

@section('action-btn')
    @can('create project')
        <div class="float-end">
            <a href="{{ route('construction.gantt', $project->id) }}" class="btn btn-sm btn-info me-1">
                <i class="ti ti-calendar-time"></i> {{ __('Gantt Chart') }}
            </a>
            <a href="#" data-url="{{ route('construction.stages.library', $project->id) }}" data-ajax-popup="true"
                data-title="{{ __('Import from Library') }}" data-size="lg" class="btn btn-sm btn-light-primary me-1">
                <i class="ti ti-download"></i> {{ __('Import') }}
            </a>
            <a href="#" data-url="{{ route('construction.stages.create', $project->id) }}" data-ajax-popup="true"
                data-title="{{ __('Create Construction Stage') }}" data-size="lg" class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i> {{ __('Create Stage') }}
            </a>
        </div>
    @endcan
@endsection

@push('script-page')
    <script src="{{ asset('assets/js/jquery-ui.min.js') }}"></script>
    <script>
        $(function () {
            $(".sortable").sortable({
                handle: '.sort-handle',
                stop: function () {
                    var order = [];
                    $(this).find('li').each(function (index, data) {
                        order[index] = $(data).attr('data-id');
                    });
                    $.ajax({
                        url: "{{ route('construction.stages.order', $project->id) }}",
                        data: { order: order, _token: '{{ csrf_token() }}' },
                        type: 'POST',
                        success: function (data) {
                            show_toastr('{{ __("Success") }}', '{{ __("Order updated successfully") }}', 'success');
                        },
                        error: function (data) {
                            show_toastr('{{ __("Error") }}', '{{ __("Something went wrong") }}', 'error');
                        }
                    });
                }
            });
        });
    </script>
@endpush

@section('content')
@php($settings = \App\Models\Utility::settings())
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5>{{ __('Project Budget Overview') }}</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h6 class="text-muted">{{ __('Total Budget Allocated') }}</h6>
                            <h4 class="text-primary">
                                @if($project->getTotalConstructionBudget() > 0)
                                    {{ Utility::priceFormat($settings, $project->getTotalConstructionBudget()) }}
                                @else
                                    <span class="text-muted">{{ __('Not Set') }}</span>
                                @endif
                            </h4>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h6 class="text-muted">{{ __('Total Spent') }}</h6>
                            <h4 class="text-info">
                                {{ Utility::priceFormat($settings, $project->getTotalConstructionSpent()) }}
                            </h4>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h6 class="text-muted">{{ __('Remaining Budget') }}</h6>
                            <h4
                                class="{{ $project->getTotalConstructionBudget() > 0 && $project->getTotalConstructionSpent() > $project->getTotalConstructionBudget() ? 'text-danger' : 'text-success' }}">
                                @if($project->getTotalConstructionBudget() > 0)
                                    {{ Utility::priceFormat($settings, $project->getTotalConstructionBudget() - $project->getTotalConstructionSpent()) }}
                                @else
                                    <span class="text-muted">{{ __('N/A') }}</span>
                                @endif
                            </h4>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h6 class="text-muted">{{ __('Overall Progress') }}</h6>
                            <h4 class="text-success">{{ $project->getConstructionProgress() }}%</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5>{{ __('Construction Stages') }}</h5>
                <small class="text-muted">{{ __('Drag and drop to reorder stages') }}</small>
            </div>
            <div class="card-body">
                @if($floors->count() > 0 || $stages->count() > 0)
                    <div class="accordion" id="accordionFloors">
                        @foreach ($floors as $floor)
                            <div class="accordion-item mb-3">
                                <h2 class="accordion-header" id="heading{{ $floor->id }}">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapse{{ $floor->id }}" aria-expanded="true"
                                        aria-controls="collapse{{ $floor->id }}">
                                        <div class="d-flex justify-content-between w-100 align-items-center me-3">
                                            <div>
                                                <i class="ti ti-layers-intersect me-2"></i> {{ $floor->name }}
                                            </div>
                                            <div class="text-end">
                                                <small class="text-muted d-block">{{ __('Total Budget') }}</small>
                                                <span class="text-primary font-weight-bold">
                                                    {{ Utility::priceFormat($settings, $floor->stages->sum('budget_allocated')) }}
                                                </span>
                                            </div>
                                        </div>
                                    </button>
                                </h2>
                                <div id="collapse{{ $floor->id }}" class="accordion-collapse collapse show"
                                    aria-labelledby="heading{{ $floor->id }}">
                                    <div class="accordion-body p-0">
                                        @if($floor->stages->count() > 0)
                                            <ul class="list-group list-group-flush sortable" data-floor-id="{{ $floor->id }}">
                                                @foreach ($floor->stages as $stage)
                                                    @include('construction.stages.section_stage_row', ['stage' => $stage, 'settings' => $settings])
                                                @endforeach
                                            </ul>
                                        @else
                                            <div class="text-center py-3">
                                                <small class="text-muted">{{ __('No stages assigned to this floor yet.') }}</small>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        @endforeach

                        @if($stages->count() > 0)
                            <div class="accordion-item mb-3">
                                <h2 class="accordion-header" id="headingUnassigned">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse"
                                        data-bs-target="#collapseUnassigned" aria-expanded="true"
                                        aria-controls="collapseUnassigned">
                                        <div class="d-flex justify-content-between w-100 align-items-center me-3">
                                            <div>
                                                <i class="ti ti-package me-2"></i> {{ __('General / Unassigned') }}
                                            </div>
                                        </div>
                                    </button>
                                </h2>
                                <div id="collapseUnassigned" class="accordion-collapse collapse show"
                                    aria-labelledby="headingUnassigned">
                                    <div class="accordion-body p-0">
                                        <ul class="list-group list-group-flush sortable" data-floor-id="0">
                                            @foreach ($stages as $stage)
                                                @include('construction.stages.section_stage_row', ['stage' => $stage, 'settings' => $settings])
                                            @endforeach
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="ti ti-building" style="font-size: 48px; opacity: 0.3;"></i>
                        <p class="text-muted mt-3">{{ __('No construction stages found.') }}</p>
                        <p class="text-muted">
                            {{ __('Click "Create Stage" button above to add your first construction stage.') }}
                        </p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection