{{ Form::open(['route' => ['construction.stages.store', $project->id], 'method' => 'post']) }}
<div class="modal-body">
    <div class="row">
        <div class="form-group col-md-12">
            {{ Form::label('construction_floor_id', __('Floor (Optional)'), ['class' => 'form-label']) }}
            {{ Form::select('construction_floor_id', $floors, null, ['class' => 'form-control select', 'placeholder' => __('Select Floor')]) }}
        </div>
        <div class="form-group col-md-12">
            {{ Form::label('name', __('Stage Name'), ['class' => 'form-label']) }}
            {{ Form::text('name', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => __('e.g., Foundation Work')]) }}
        </div>

        <div class="form-group col-md-12">
            {{ Form::label('description', __('Description'), ['class' => 'form-label']) }}
            {{ Form::textarea('description', null, ['class' => 'form-control', 'rows' => 3, 'placeholder' => __('Describe this construction stage...')]) }}
        </div>

        <div class="form-group col-md-6">
            {{ Form::label('budget_allocated', __('Budget Allocated (Optional)'), ['class' => 'form-label']) }}
            {{ Form::number('budget_allocated', null, ['class' => 'form-control', 'step' => '0.01', 'min' => '0', 'placeholder' => '0.00']) }}
            <small class="text-muted">{{ __('Leave blank if budget is not known yet') }}</small>
        </div>

        <div class="form-group col-md-6">
            {{ Form::label('status', __('Status'), ['class' => 'form-label']) }}
            {{ Form::select('status', \App\Models\ConstructionStage::$statuses, 'pending', ['class' => 'form-control select']) }}
        </div>

        <div class="form-group col-md-6">
            {{ Form::label('start_date', __('Start Date'), ['class' => 'form-label']) }}
            {{ Form::date('start_date', null, ['class' => 'form-control']) }}
        </div>

        <div class="form-group col-md-6">
            {{ Form::label('end_date', __('End Date'), ['class' => 'form-label']) }}
            {{ Form::date('end_date', null, ['class' => 'form-control']) }}
        </div>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
    <button type="submit" class="btn btn-primary">{{ __('Create') }}</button>
</div>
{{ Form::close() }}