@extends('layouts.admin')
@php($settings = \App\Models\Utility::settings())

@section('page-title')
    {{ __('Construction Activities') }} - {{ $stage->name }}
@endsection

@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Dashboard') }}</a></li>
    <li class="breadcrumb-item"><a href="{{ route('projects.index') }}">{{ __('Projects') }}</a></li>
    <li class="breadcrumb-item"><a href="{{ route('projects.show', $project->id) }}">{{ $project->project_name }}</a></li>
    <li class="breadcrumb-item"><a href="{{ route('construction.stages.index', $project->id) }}">{{ __('Stages') }}</a></li>
    <li class="breadcrumb-item">{{ $stage->name }}</li>
@endsection

@section('action-btn')
    @can('create project')
        <div class="float-end">
            <a href="{{ route('construction.stages.index', $project->id) }}" class="btn btn-sm btn-secondary">
                <i class="ti ti-arrow-left"></i> {{ __('Back to Stages') }}
            </a>
            <a href="{{ route('construction.gantt', $project->id) }}" class="btn btn-sm btn-info">
                <i class="ti ti-calendar-time"></i> {{ __('Gantt Chart') }}
            </a>
            <a href="#" data-url="{{ route('construction.activities.create', $stage->id) }}"
               data-ajax-popup="true"
               data-title="{{ __('Create Construction Activity') }}"
               data-size="lg"
               class="btn btn-sm btn-primary">
                <i class="ti ti-plus"></i> {{ __('Create Activity') }}
            </a>
        </div>
    @endcan
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5>{{ __('Stage Overview') }}: {{ $stage->name }}</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-3">
                            <div class="text-center">
                                <h6 class="text-muted">{{ __('Budget Allocated') }}</h6>
                                <h4 class="text-primary">
                                    @if($stage->hasBudget())
                                        {{ \App\Models\Utility::priceFormat($settings, $stage->budget_allocated) }}
                                    @else
                                        <span class="text-muted">{{ __('Not Set') }}</span>
                                    @endif
                                </h4>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h6 class="text-muted">{{ __('Budget Spent') }}</h6>
                                <h4 class="{{ $stage->isOverBudget() ? 'text-danger' : 'text-success' }}">
                                    {{ \App\Models\Utility::priceFormat($settings, $stage->getBudgetSpent()) }}
                                </h4>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h6 class="text-muted">{{ __('Budget Remaining') }}</h6>
                                <h4 class="text-info">
                                    @if($stage->hasBudget())
                                        {{ \App\Models\Utility::priceFormat($settings, $stage->getBudgetRemaining()) }}
                                    @else
                                        <span class="text-muted">{{ __('N/A') }}</span>
                                    @endif
                                </h4>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="text-center">
                                <h6 class="text-muted">{{ __('Progress') }}</h6>
                                <h4 class="text-success">{{ $stage->getProgressPercentage() }}%</h4>
                            </div>
                        </div>
                    </div>
                    @if($stage->description)
                        <div class="row mt-3">
                            <div class="col-12">
                                <p class="text-muted mb-0"><strong>{{ __('Description') }}:</strong></p>
                                <p>{{ $stage->description }}</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h5>{{ __('Construction Activities') }}</h5>
                </div>
                <div class="card-body table-border-style">
                    @if($activities->count() > 0)
                        <div class="table-responsive">
                            <table class="table datatable">
                                <thead>
                                    <tr>
                                        <th>{{ __('Activity Name') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Progress') }}</th>
                                        <th>{{ __('Estimated Cost') }}</th>
                                        <th>{{ __('Actual Cost') }}</th>
                                        <th>{{ __('Variance') }}</th>
                                        <th>{{ __('Assigned To') }}</th>
                                        <th>{{ __('Duration') }}</th>
                                        <th>{{ __('Action') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($activities as $activity)
                                        <tr>
                                            <td>{{ $activity->name }}</td>
                                            <td>
                                                <span class="badge badge-{{ $activity->getStatusBadgeColor() }}">
                                                    {{ $activity->getStatusLabel() }}
                                                </span>
                                            </td>
                                            <td>
                                                <div class="progress" style="height: 8px;">
                                                    <div class="progress-bar bg-success" role="progressbar"
                                                         style="width: {{ $activity->progress_percentage }}%"></div>
                                                </div>
                                                <small>{{ $activity->progress_percentage }}%</small>
                                            </td>
                                            <td>
                                                @if($activity->hasEstimate())
                                                    {{ \App\Models\Utility::priceFormat($settings, $activity->estimated_cost) }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td class="{{ $activity->isOverBudget() ? 'text-danger' : '' }}">
                                                @if($activity->actual_cost)
                                                    {{ \App\Models\Utility::priceFormat($settings, $activity->actual_cost) }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td class="{{ $activity->getCostVariance() && $activity->getCostVariance() < 0 ? 'text-danger' : 'text-success' }}">
                                                @if($activity->getCostVariance())
                                                    {{ \App\Models\Utility::priceFormat($settings, $activity->getCostVariance()) }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($activity->assignedUsers()->count() > 0)
                                                    <div class="avatar-group">
                                                        @foreach($activity->assignedUsers()->take(3) as $user)
                                                            <a href="#" class="avatar rounded-circle avatar-sm"
                                                               data-bs-toggle="tooltip" title="{{ $user->name }}">
                                                                <img alt="{{ $user->name }}" src="{{ $user->getImgImageAttribute() }}">
                                                            </a>
                                                        @endforeach
                                                        @if($activity->assignedUsers()->count() > 3)
                                                            <a href="#" class="avatar rounded-circle avatar-sm">
                                                                <span>+{{ $activity->assignedUsers()->count() - 3 }}</span>
                                                            </a>
                                                        @endif
                                                    </div>
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($activity->start_date && $activity->end_date)
                                                    {{ $activity->start_date->format('d M') }} - {{ $activity->end_date->format('d M') }}
                                                @else
                                                    <span class="text-muted">-</span>
                                                @endif
                                            </td>
                                            <td>
                                                @can('edit project')
                                                    <div class="action-btn bg-primary ms-2">
                                                        <a href="#" data-url="{{ route('construction.activities.edit', $activity->id) }}"
                                                           data-ajax-popup="true"
                                                           data-title="{{ __('Edit Activity') }}"
                                                           data-size="lg"
                                                           class="mx-3 btn btn-sm d-inline-flex align-items-center"
                                                           data-bs-toggle="tooltip"
                                                           title="{{ __('Edit') }}">
                                                            <i class="ti ti-pencil text-white"></i>
                                                        </a>
                                                    </div>
                                                @endcan
                                                @can('delete project')
                                                    <div class="action-btn bg-danger ms-2">
                                                        {!! Form::open(['method' => 'DELETE', 'route' => ['construction.activities.destroy', $activity->id], 'class' => 'd-inline']) !!}
                                                        <a href="#"
                                                           class="mx-3 btn btn-sm d-inline-flex align-items-center bs-pass-para"
                                                           data-bs-toggle="tooltip"
                                                           title="{{ __('Delete') }}">
                                                            <i class="ti ti-trash text-white"></i>
                                                        </a>
                                                        {!! Form::close() !!}
                                                    </div>
                                                @endcan
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="text-center py-5">
                            <i class="ti ti-checklist" style="font-size: 48px; opacity: 0.3;"></i>
                            <p class="text-muted mt-3">{{ __('No construction activities found for this stage.') }}</p>
                            <p class="text-muted">{{ __('Click "Create Activity" button above to add your first activity.') }}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
