{{ Form::model($activity, ['route' => ['construction.activities.update', $activity->id], 'method' => 'post']) }}
<div class="modal-body">
    <div class="row">
        <div class="form-group col-md-12">
            {{ Form::label('name', __('Activity Name'), ['class' => 'form-label']) }}
            {{ Form::text('name', null, ['class' => 'form-control', 'required' => 'required', 'placeholder' => __('e.g., Concrete Pouring')]) }}
        </div>

        <div class="form-group col-md-12">
            {{ Form::label('description', __('Description'), ['class' => 'form-label']) }}
            {{ Form::textarea('description', null, ['class' => 'form-control', 'rows' => 2, 'placeholder' => __('Describe this activity...')]) }}
        </div>

        <div class="form-group col-md-6">
            {{ Form::label('estimated_cost', __('Estimated Cost (Optional)'), ['class' => 'form-label']) }}
            {{ Form::number('estimated_cost', null, ['class' => 'form-control', 'step' => '0.01', 'min' => '0', 'placeholder' => '0.00']) }}
            <small class="text-muted">{{ __('Can be added later') }}</small>
        </div>

        <div class="form-group col-md-6">
            {{ Form::label('actual_cost', __('Actual Cost (Optional)'), ['class' => 'form-label']) }}
            {{ Form::number('actual_cost', null, ['class' => 'form-control', 'step' => '0.01', 'min' => '0', 'placeholder' => '0.00']) }}
            <small class="text-muted">{{ __('Updated as expenses occur') }}</small>
        </div>

        <div class="form-group col-md-4">
            {{ Form::label('labor_hours', __('Labor Hours (Optional)'), ['class' => 'form-label']) }}
            {{ Form::number('labor_hours', null, ['class' => 'form-control', 'step' => '0.5', 'min' => '0', 'placeholder' => '0']) }}
        </div>

        <div class="form-group col-md-4">
            {{ Form::label('material_cost', __('Material Cost (Optional)'), ['class' => 'form-label']) }}
            {{ Form::number('material_cost', null, ['class' => 'form-control', 'step' => '0.01', 'min' => '0', 'placeholder' => '0.00']) }}
        </div>

        <div class="form-group col-md-4">
            {{ Form::label('equipment_cost', __('Equipment Cost (Optional)'), ['class' => 'form-label']) }}
            {{ Form::number('equipment_cost', null, ['class' => 'form-control', 'step' => '0.01', 'min' => '0', 'placeholder' => '0.00']) }}
        </div>

        <div class="form-group col-md-6">
            {{ Form::label('status', __('Status'), ['class' => 'form-label']) }}
            {{ Form::select('status', \App\Models\ConstructionActivity::$statuses, null, ['class' => 'form-control select']) }}
        </div>

        <div class="form-group col-md-6">
            {{ Form::label('progress_percentage', __('Progress %'), ['class' => 'form-label']) }}
            {{ Form::number('progress_percentage', null, ['class' => 'form-control', 'min' => '0', 'max' => '100', 'placeholder' => '0']) }}
        </div>

        <div class="form-group col-md-12">
            {{ Form::label('assigned_to', __('Assign To'), ['class' => 'form-label']) }}
            {{ Form::select('assigned_to[]', $users, explode(',', $activity->assigned_to), ['class' => 'form-control select2', 'multiple' => 'multiple']) }}
        </div>

        <div class="form-group col-md-6">
            {{ Form::label('start_date', __('Start Date'), ['class' => 'form-label']) }}
            {{ Form::date('start_date', null, ['class' => 'form-control']) }}
        </div>

        <div class="form-group col-md-6">
            {{ Form::label('end_date', __('End Date'), ['class' => 'form-label']) }}
            {{ Form::date('end_date', null, ['class' => 'form-control']) }}
        </div>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-light" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
    <button type="submit" class="btn btn-primary">{{ __('Update') }}</button>
</div>
{{ Form::close() }}
