@extends('layouts.admin')
@section('page-title')
    {{__('Budget Alerts Dashboard')}}
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{route('dashboard')}}">{{__('Dashboard')}}</a></li>
    <li class="breadcrumb-item"><a href="{{route('budget.index')}}">{{__('Budget Planner')}}</a></li>
    <li class="breadcrumb-item">{{__('Budget Alerts')}}</li>
@endsection

@section('action-btn')
    <div class="float-end">
        <button id="refresh-alerts" class="btn btn-sm btn-primary" data-bs-toggle="tooltip" title="{{__('Refresh Alerts')}}">
            <i class="ti ti-refresh"></i> {{__('Refresh')}}
        </button>
    </div>
@endsection

@push('css-page')
<style>
    .alert-card {
        border-left: 4px solid;
        transition: all 0.3s ease;
    }
    .alert-card:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    }
    .alert-overrun {
        border-left-color: #dc3545;
        background: linear-gradient(135deg, #fff5f5 0%, #ffffff 100%);
    }
    .alert-critical {
        border-left-color: #fd7e14;
        background: linear-gradient(135deg, #fff8f0 0%, #ffffff 100%);
    }
    .alert-warning {
        border-left-color: #ffc107;
        background: linear-gradient(135deg, #fffbf0 0%, #ffffff 100%);
    }
    .alert-safe {
        border-left-color: #198754;
        background: linear-gradient(135deg, #f0fff4 0%, #ffffff 100%);
    }
    .status-badge {
        font-size: 0.75rem;
        padding: 0.25rem 0.5rem;
        border-radius: 0.375rem;
        font-weight: 600;
        text-transform: uppercase;
    }
    .status-overrun {
        background-color: #dc3545;
        color: white;
    }
    .status-critical {
        background-color: #fd7e14;
        color: white;
    }
    .status-warning {
        background-color: #ffc107;
        color: #000;
    }
    .status-safe {
        background-color: #198754;
        color: white;
    }
    .progress-bar-overrun {
        background-color: #dc3545;
    }
    .progress-bar-critical {
        background-color: #fd7e14;
    }
    .progress-bar-warning {
        background-color: #ffc107;
    }
    .progress-bar-safe {
        background-color: #198754;
    }
    .stat-card {
        border-radius: 0.5rem;
        border: none;
        box-shadow: 0 2px 4px rgba(0,0,0,0.1);
    }
</style>
@endpush

@section('content')
    <!-- Alert Statistics -->
    <div class="row mb-4">
        <div class="col-xl-3 col-md-6">
            <div class="card stat-card bg-danger text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="theme-avtar bg-white text-danger">
                            <i class="ti ti-alert-triangle"></i>
                        </div>
                        <div class="ms-3">
                            <h3 class="mb-0">{{$alertStats['overrun']}}</h3>
                            <p class="mb-0">{{__('Overrun Alerts')}}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card stat-card bg-warning text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="theme-avtar bg-white text-warning">
                            <i class="ti ti-alert-circle"></i>
                        </div>
                        <div class="ms-3">
                            <h3 class="mb-0">{{$alertStats['critical']}}</h3>
                            <p class="mb-0">{{__('Critical Alerts')}}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card stat-card bg-info text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="theme-avtar bg-white text-info">
                            <i class="ti ti-info-circle"></i>
                        </div>
                        <div class="ms-3">
                            <h3 class="mb-0">{{$alertStats['warning']}}</h3>
                            <p class="mb-0">{{__('Warning Alerts')}}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card stat-card bg-success text-white">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="theme-avtar bg-white text-success">
                            <i class="ti ti-check-circle"></i>
                        </div>
                        <div class="ms-3">
                            <h3 class="mb-0">{{$alertStats['total']}}</h3>
                            <p class="mb-0">{{__('Total Active Alerts')}}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Active Alerts -->
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h5>{{__('Active Budget Alerts')}}</h5>
                </div>
                <div class="card-body">
                    @if($activeAlerts->count() > 0)
                        <div class="row">
                            @foreach($activeAlerts as $alert)
                                <div class="col-12 mb-3">
                                    <div class="card alert-card alert-{{$alert->alert_type}}">
                                        <div class="card-body">
                                            <div class="row align-items-center">
                                                <div class="col-md-6">
                                                    <div class="d-flex align-items-center">
                                                        <div class="me-3">
                                                            @if($alert->alert_type == 'overrun')
                                                                <i class="ti ti-alert-triangle text-danger" style="font-size: 1.5rem;"></i>
                                                            @elseif($alert->alert_type == 'critical')
                                                                <i class="ti ti-alert-circle text-warning" style="font-size: 1.5rem;"></i>
                                                            @else
                                                                <i class="ti ti-info-circle text-info" style="font-size: 1.5rem;"></i>
                                                            @endif
                                                        </div>
                                                        <div>
                                                            <h6 class="mb-1">{{$alert->budget->name}}</h6>
                                                            <p class="mb-0 text-muted small">{{$alert->message}}</p>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="text-center">
                                                        <span class="status-badge status-{{$alert->alert_type}}">
                                                            {{ucfirst($alert->alert_type)}}
                                                        </span>
                                                        <div class="mt-2">
                                                            <strong>{{number_format($alert->current_percentage, 1)}}%</strong>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-3">
                                                    <div class="text-end">
                                                        <div class="btn-group" role="group">
                                                            <button class="btn btn-sm btn-outline-primary acknowledge-btn" 
                                                                    data-alert-id="{{$alert->id}}" 
                                                                    data-bs-toggle="tooltip" 
                                                                    title="{{__('Acknowledge')}}">
                                                                <i class="ti ti-check"></i>
                                                            </button>
                                                            <button class="btn btn-sm btn-outline-success resolve-btn" 
                                                                    data-alert-id="{{$alert->id}}" 
                                                                    data-bs-toggle="tooltip" 
                                                                    title="{{__('Resolve')}}">
                                                                <i class="ti ti-check-circle"></i>
                                                            </button>
                                                            <button class="btn btn-sm btn-outline-info view-details-btn" 
                                                                    data-alert-id="{{$alert->id}}" 
                                                                    data-bs-toggle="tooltip" 
                                                                    title="{{__('View Details')}}">
                                                                <i class="ti ti-eye"></i>
                                                            </button>
                                                        </div>
                                                        <div class="mt-2 small text-muted">
                                                            {{$alert->triggered_at->diffForHumans()}}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @else
                        <div class="text-center py-4">
                            <i class="ti ti-check-circle text-success" style="font-size: 3rem;"></i>
                            <h5 class="mt-3">{{__('No Active Alerts')}}</h5>
                            <p class="text-muted">{{__('All your budgets are within safe limits.')}}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>

        <!-- Budget Status Overview -->
        <div class="col-lg-4">
            <div class="card">
                <div class="card-header">
                    <h5>{{__('Budget Status Overview')}}</h5>
                </div>
                <div class="card-body">
                    @if(count($budgetStatuses) > 0)
                        @foreach($budgetStatuses as $budgetStatus)
                            <div class="mb-3 p-3 rounded alert-{{$budgetStatus['status']}}">
                                <div class="d-flex justify-content-between align-items-center mb-2">
                                    <h6 class="mb-0">{{$budgetStatus['budget']->name}}</h6>
                                    <span class="status-badge status-{{$budgetStatus['status']}}">
                                        {{ucfirst($budgetStatus['status'])}}
                                    </span>
                                </div>
                                <div class="progress mb-2" style="height: 8px;">
                                    <div class="progress-bar progress-bar-{{$budgetStatus['status']}}" 
                                         role="progressbar" 
                                         style="width: {{min($budgetStatus['percentage'], 100)}}%"
                                         aria-valuenow="{{$budgetStatus['percentage']}}" 
                                         aria-valuemin="0" 
                                         aria-valuemax="100">
                                    </div>
                                </div>
                                <div class="d-flex justify-content-between small text-muted">
                                    <span>${{number_format($budgetStatus['spent_amount'], 2)}} / ${{number_format($budgetStatus['budget_amount'], 2)}}</span>
                                    <span>{{number_format($budgetStatus['percentage'], 1)}}%</span>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div class="text-center py-4">
                            <i class="ti ti-folder-x text-muted" style="font-size: 2rem;"></i>
                            <p class="text-muted mt-2">{{__('No budgets found.')}}</p>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Recent Alerts -->
            <div class="card mt-4">
                <div class="card-header">
                    <h5>{{__('Recent Alerts')}}</h5>
                </div>
                <div class="card-body">
                    @if($recentAlerts->count() > 0)
                        @foreach($recentAlerts->take(5) as $alert)
                            <div class="d-flex align-items-center mb-3">
                                <div class="me-3">
                                    @if($alert->alert_type == 'overrun')
                                        <i class="ti ti-alert-triangle text-danger"></i>
                                    @elseif($alert->alert_type == 'critical')
                                        <i class="ti ti-alert-circle text-warning"></i>
                                    @else
                                        <i class="ti ti-info-circle text-info"></i>
                                    @endif
                                </div>
                                <div class="flex-grow-1">
                                    <h6 class="mb-0 small">{{$alert->budget->name}}</h6>
                                    <p class="mb-0 text-muted small">{{$alert->triggered_at->format('M j, Y')}}</p>
                                </div>
                                <div>
                                    <span class="badge bg-{{$alert->alert_type == 'overrun' ? 'danger' : ($alert->alert_type == 'critical' ? 'warning' : 'info')}}">
                                        {{number_format($alert->current_percentage, 1)}}%
                                    </span>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div class="text-center py-3">
                            <p class="text-muted small">{{__('No recent alerts.')}}</p>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>

    <!-- Alert Details Modal -->
    <div class="modal fade" id="alertDetailsModal" tabindex="-1" aria-labelledby="alertDetailsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="alertDetailsModalLabel">{{__('Alert Details')}}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="alertDetailsContent">
                    <!-- Content will be loaded dynamically -->
                </div>
            </div>
        </div>
    </div>

    <!-- Acknowledge Modal -->
    <div class="modal fade" id="acknowledgeModal" tabindex="-1" aria-labelledby="acknowledgeModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="acknowledgeModalLabel">{{__('Acknowledge Alert')}}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="acknowledgeForm">
                        <div class="mb-3">
                            <label for="acknowledgeNotes" class="form-label">{{__('Notes (Optional)')}}</label>
                            <textarea class="form-control" id="acknowledgeNotes" name="notes" rows="3" placeholder="{{__('Add any notes about this acknowledgment...')}}"></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                    <button type="button" class="btn btn-primary" id="confirmAcknowledge">{{__('Acknowledge')}}</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Resolve Modal -->
    <div class="modal fade" id="resolveModal" tabindex="-1" aria-labelledby="resolveModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="resolveModalLabel">{{__('Resolve Alert')}}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form id="resolveForm">
                        <div class="mb-3">
                            <label for="resolveNotes" class="form-label">{{__('Resolution Notes')}}</label>
                            <textarea class="form-control" id="resolveNotes" name="notes" rows="3" placeholder="{{__('Describe how this alert was resolved...')}}" required></textarea>
                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{__('Cancel')}}</button>
                    <button type="button" class="btn btn-success" id="confirmResolve">{{__('Resolve')}}</button>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script-page')
<script>
$(document).ready(function() {
    let currentAlertId = null;

    // Refresh alerts
    $('#refresh-alerts').click(function() {
        const btn = $(this);
        const originalText = btn.html();
        btn.html('<i class="ti ti-loader"></i> {{__("Refreshing...")}}').prop('disabled', true);

        $.ajax({
            url: '{{ route("budget-alerts.refresh") }}',
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert(response.message || '{{__("Failed to refresh alerts.")}}');
                }
            },
            error: function() {
                alert('{{__("Failed to refresh alerts.")}}');
            },
            complete: function() {
                btn.html(originalText).prop('disabled', false);
            }
        });
    });

    // Acknowledge alert
    $('.acknowledge-btn').click(function() {
        currentAlertId = $(this).data('alert-id');
        $('#acknowledgeModal').modal('show');
    });

    $('#confirmAcknowledge').click(function() {
        const notes = $('#acknowledgeNotes').val();
        
        $.ajax({
            url: `/budget-alerts/${currentAlertId}/acknowledge`,
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: { notes: notes },
            success: function(response) {
                if (response.success) {
                    $('#acknowledgeModal').modal('hide');
                    location.reload();
                } else {
                    alert(response.message || '{{__("Failed to acknowledge alert.")}}');
                }
            },
            error: function() {
                alert('{{__("Failed to acknowledge alert.")}}');
            }
        });
    });

    // Resolve alert
    $('.resolve-btn').click(function() {
        currentAlertId = $(this).data('alert-id');
        $('#resolveModal').modal('show');
    });

    $('#confirmResolve').click(function() {
        const notes = $('#resolveNotes').val();
        
        if (!notes.trim()) {
            alert('{{__("Please provide resolution notes.")}}');
            return;
        }
        
        $.ajax({
            url: `/budget-alerts/${currentAlertId}/resolve`,
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            data: { notes: notes },
            success: function(response) {
                if (response.success) {
                    $('#resolveModal').modal('hide');
                    location.reload();
                } else {
                    alert(response.message || '{{__("Failed to resolve alert.")}}');
                }
            },
            error: function() {
                alert('{{__("Failed to resolve alert.")}}');
            }
        });
    });

    // View alert details
    $('.view-details-btn').click(function() {
        const alertId = $(this).data('alert-id');
        
        $.ajax({
            url: `/budget-alerts/${alertId}`,
            method: 'GET',
            success: function(response) {
                if (response.success) {
                    const alert = response.alert;
                    const content = `
                        <div class="row">
                            <div class="col-md-6">
                                <h6>{{__('Budget Information')}}</h6>
                                <p><strong>{{__('Budget Name')}}:</strong> ${alert.budget.name}</p>
                                <p><strong>{{__('Period')}}:</strong> ${alert.budget.from} - ${alert.budget.to}</p>
                                <p><strong>{{__('Alert Type')}}:</strong> <span class="badge bg-${alert.alert_type == 'overrun' ? 'danger' : (alert.alert_type == 'critical' ? 'warning' : 'info')}">${alert.alert_type.charAt(0).toUpperCase() + alert.alert_type.slice(1)}</span></p>
                            </div>
                            <div class="col-md-6">
                                <h6>{{__('Financial Details')}}</h6>
                                <p><strong>{{__('Budget Amount')}}:</strong> $${parseFloat(alert.budget_amount).toLocaleString()}</p>
                                <p><strong>{{__('Spent Amount')}}:</strong> $${parseFloat(alert.spent_amount).toLocaleString()}</p>
                                <p><strong>{{__('Current Percentage')}}:</strong> ${parseFloat(alert.current_percentage).toFixed(1)}%</p>
                            </div>
                        </div>
                        <hr>
                        <div class="row">
                            <div class="col-12">
                                <h6>{{__('Alert Details')}}</h6>
                                <p><strong>{{__('Message')}}:</strong> ${alert.message}</p>
                                <p><strong>{{__('Triggered At')}}:</strong> ${new Date(alert.triggered_at).toLocaleString()}</p>
                                <p><strong>{{__('Status')}}:</strong> <span class="badge bg-${alert.status == 'active' ? 'primary' : (alert.status == 'acknowledged' ? 'warning' : 'success')}">${alert.status.charAt(0).toUpperCase() + alert.status.slice(1)}</span></p>
                            </div>
                        </div>
                    `;
                    $('#alertDetailsContent').html(content);
                    $('#alertDetailsModal').modal('show');
                } else {
                    alert(response.message || '{{__("Failed to load alert details.")}}');
                }
            },
            error: function() {
                alert('{{__("Failed to load alert details.")}}');
            }
        });
    });

    // Clear modal forms when closed
    $('.modal').on('hidden.bs.modal', function() {
        $(this).find('form')[0]?.reset();
        currentAlertId = null;
    });
});
</script>
@endpush