<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use App\Models\User;

class VenderSampleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $owner = User::where('type', 'company')->first() ?? User::first();
        $createdBy = $owner ? $owner->creatorId() : 1;

        $startVenderId = (int) (DB::table('venders')->where('created_by', $createdBy)->max('vender_id') ?? 0);

        $now = now();

        $vendors = [
            ['name' => 'Alpha Supplies Co',       'email' => 'alpha.supplies@example.com',      'contact' => '+91-9000000001'],
            ['name' => 'Beta Building Materials', 'email' => 'beta.materials@example.com',      'contact' => '+91-9000000002'],
            ['name' => 'Gamma Aggregates',        'email' => 'gamma.aggregates@example.com',    'contact' => '+91-9000000003'],
            ['name' => 'Delta Steel Traders',     'email' => 'delta.steel@example.com',         'contact' => '+91-9000000004'],
            ['name' => 'Epsilon Cement Works',    'email' => 'epsilon.cement@example.com',      'contact' => '+91-9000000005'],
            ['name' => 'Zeta Hardware Mart',      'email' => 'zeta.hardware@example.com',       'contact' => '+91-9000000006'],
            ['name' => 'Eta Electricals',         'email' => 'eta.electricals@example.com',     'contact' => '+91-9000000007'],
            ['name' => 'Theta Timber Co',         'email' => 'theta.timber@example.com',        'contact' => '+91-9000000008'],
        ];

        $rows = [];
        foreach ($vendors as $i => $v) {
            $rows[] = [
                'vender_id'       => $startVenderId + $i + 1,
                'name'            => $v['name'],
                'email'           => $v['email'],
                'contact'         => $v['contact'],
                'is_active'       => 1,
                'created_by'      => $createdBy,
                'billing_name'    => $v['name'],
                'billing_phone'   => $v['contact'],
                'billing_address' => null,
                'billing_zip'     => null,
                'billing_country' => null,
                'billing_state'   => null,
                'billing_city'    => null,
                'shipping_name'   => $v['name'],
                'shipping_phone'  => $v['contact'],
                'shipping_address'=> null,
                'shipping_zip'    => null,
                'shipping_country'=> null,
                'shipping_state'  => null,
                'shipping_city'   => null,
                'created_at'      => $now,
                'updated_at'      => $now,
            ];
        }

        DB::table('venders')->insert($rows);
    }
}