<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\NotificationTemplates;
use App\Models\NotificationTemplateLangs;

class BudgetAlertNotificationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $notifications = [
            'budget_warning_alert' => 'Budget Warning Alert',
            'budget_critical_alert' => 'Budget Critical Alert', 
            'budget_overrun_alert' => 'Budget Overrun Alert'
        ];

        $defaultTemplate = [
            'notification' => [
                'budget_warning_alert' => [
                    'variables' => '{
                        "budget_name": "Budget Name",
                        "current_percentage": "Current Percentage",
                        "threshold_percentage": "Threshold Percentage", 
                        "spent_amount": "Spent Amount",
                        "budget_amount": "Budget Amount",
                        "alert_type": "Alert Type",
                        "user_name": "User Name"
                    }',
                    'lang' => [
                        'ar' => 'تحذير الميزانية: {budget_name} وصل إلى {current_percentage}% من الميزانية. تم إنفاق {spent_amount} من {budget_amount}',
                        'zh' => '预算警告：{budget_name} 已达到预算的 {current_percentage}%。已花费 {spent_amount} / {budget_amount}',
                        'da' => 'Budget advarsel: {budget_name} har nået {current_percentage}% af budgettet. Brugt {spent_amount} af {budget_amount}',
                        'de' => 'Budget-Warnung: {budget_name} hat {current_percentage}% des Budgets erreicht. Ausgegeben {spent_amount} von {budget_amount}',
                        'en' => 'Budget Warning: {budget_name} has reached {current_percentage}% of budget. Spent {spent_amount} of {budget_amount}',
                        'es' => 'Advertencia de presupuesto: {budget_name} ha alcanzado el {current_percentage}% del presupuesto. Gastado {spent_amount} de {budget_amount}',
                        'fr' => 'Avertissement budgétaire: {budget_name} a atteint {current_percentage}% du budget. Dépensé {spent_amount} sur {budget_amount}',
                        'he' => 'אזהרת תקציב: {budget_name} הגיע ל-{current_percentage}% מהתקציב. הוצאו {spent_amount} מתוך {budget_amount}',
                        'it' => 'Avviso budget: {budget_name} ha raggiunto il {current_percentage}% del budget. Speso {spent_amount} di {budget_amount}',
                        'ja' => '予算警告：{budget_name} が予算の {current_percentage}% に達しました。{budget_amount} のうち {spent_amount} を使用',
                        'nl' => 'Budget waarschuwing: {budget_name} heeft {current_percentage}% van het budget bereikt. Uitgegeven {spent_amount} van {budget_amount}',
                        'pl' => 'Ostrzeżenie budżetowe: {budget_name} osiągnął {current_percentage}% budżetu. Wydano {spent_amount} z {budget_amount}',
                        'ru' => 'Предупреждение о бюджете: {budget_name} достиг {current_percentage}% бюджета. Потрачено {spent_amount} из {budget_amount}',
                        'pt' => 'Aviso de orçamento: {budget_name} atingiu {current_percentage}% do orçamento. Gasto {spent_amount} de {budget_amount}',
                        'tr' => 'Bütçe uyarısı: {budget_name} bütçenin %{current_percentage}\'sine ulaştı. {budget_amount} içinden {spent_amount} harcanmış',
                        'pt-br' => 'Aviso de orçamento: {budget_name} atingiu {current_percentage}% do orçamento. Gasto {spent_amount} de {budget_amount}',
                    ]
                ],
                'budget_critical_alert' => [
                    'variables' => '{
                        "budget_name": "Budget Name",
                        "current_percentage": "Current Percentage",
                        "threshold_percentage": "Threshold Percentage",
                        "spent_amount": "Spent Amount", 
                        "budget_amount": "Budget Amount",
                        "alert_type": "Alert Type",
                        "user_name": "User Name"
                    }',
                    'lang' => [
                        'ar' => 'تنبيه حرج للميزانية: {budget_name} وصل إلى {current_percentage}% من الميزانية! تم إنفاق {spent_amount} من {budget_amount}',
                        'zh' => '预算严重警告：{budget_name} 已达到预算的 {current_percentage}%！已花费 {spent_amount} / {budget_amount}',
                        'da' => 'Kritisk budget advarsel: {budget_name} har nået {current_percentage}% af budgettet! Brugt {spent_amount} af {budget_amount}',
                        'de' => 'Kritische Budget-Warnung: {budget_name} hat {current_percentage}% des Budgets erreicht! Ausgegeben {spent_amount} von {budget_amount}',
                        'en' => 'Budget Critical Alert: {budget_name} has reached {current_percentage}% of budget! Spent {spent_amount} of {budget_amount}',
                        'es' => 'Alerta crítica de presupuesto: ¡{budget_name} ha alcanzado el {current_percentage}% del presupuesto! Gastado {spent_amount} de {budget_amount}',
                        'fr' => 'Alerte budgétaire critique: {budget_name} a atteint {current_percentage}% du budget! Dépensé {spent_amount} sur {budget_amount}',
                        'he' => 'התראת תקציב קריטית: {budget_name} הגיע ל-{current_percentage}% מהתקציב! הוצאו {spent_amount} מתוך {budget_amount}',
                        'it' => 'Allarme budget critico: {budget_name} ha raggiunto il {current_percentage}% del budget! Speso {spent_amount} di {budget_amount}',
                        'ja' => '予算重要警告：{budget_name} が予算の {current_percentage}% に達しました！{budget_amount} のうち {spent_amount} を使用',
                        'nl' => 'Kritieke budget waarschuwing: {budget_name} heeft {current_percentage}% van het budget bereikt! Uitgegeven {spent_amount} van {budget_amount}',
                        'pl' => 'Krytyczne ostrzeżenie budżetowe: {budget_name} osiągnął {current_percentage}% budżetu! Wydano {spent_amount} z {budget_amount}',
                        'ru' => 'Критическое предупреждение о бюджете: {budget_name} достиг {current_percentage}% бюджета! Потрачено {spent_amount} из {budget_amount}',
                        'pt' => 'Alerta crítico de orçamento: {budget_name} atingiu {current_percentage}% do orçamento! Gasto {spent_amount} de {budget_amount}',
                        'tr' => 'Kritik bütçe uyarısı: {budget_name} bütçenin %{current_percentage}\'sine ulaştı! {budget_amount} içinden {spent_amount} harcanmış',
                        'pt-br' => 'Alerta crítico de orçamento: {budget_name} atingiu {current_percentage}% do orçamento! Gasto {spent_amount} de {budget_amount}',
                    ]
                ],
                'budget_overrun_alert' => [
                    'variables' => '{
                        "budget_name": "Budget Name",
                        "current_percentage": "Current Percentage",
                        "threshold_percentage": "Threshold Percentage",
                        "spent_amount": "Spent Amount",
                        "budget_amount": "Budget Amount", 
                        "alert_type": "Alert Type",
                        "user_name": "User Name"
                    }',
                    'lang' => [
                        'ar' => 'تجاوز الميزانية: {budget_name} تجاوز الميزانية بنسبة {current_percentage}%! تم إنفاق {spent_amount} من {budget_amount}',
                        'zh' => '预算超支：{budget_name} 已超出预算 {current_percentage}%！已花费 {spent_amount} / {budget_amount}',
                        'da' => 'Budget overskridelse: {budget_name} har overskredet budgettet med {current_percentage}%! Brugt {spent_amount} af {budget_amount}',
                        'de' => 'Budget-Überschreitung: {budget_name} hat das Budget um {current_percentage}% überschritten! Ausgegeben {spent_amount} von {budget_amount}',
                        'en' => 'Budget Overrun: {budget_name} has exceeded budget by {current_percentage}%! Spent {spent_amount} of {budget_amount}',
                        'es' => 'Sobrecosto de presupuesto: ¡{budget_name} ha excedido el presupuesto en {current_percentage}%! Gastado {spent_amount} de {budget_amount}',
                        'fr' => 'Dépassement budgétaire: {budget_name} a dépassé le budget de {current_percentage}%! Dépensé {spent_amount} sur {budget_amount}',
                        'he' => 'חריגה מהתקציב: {budget_name} חרג מהתקציב ב-{current_percentage}%! הוצאו {spent_amount} מתוך {budget_amount}',
                        'it' => 'Sforamento budget: {budget_name} ha superato il budget del {current_percentage}%! Speso {spent_amount} di {budget_amount}',
                        'ja' => '予算超過：{budget_name} が予算を {current_percentage}% 超過しました！{budget_amount} のうち {spent_amount} を使用',
                        'nl' => 'Budget overschrijding: {budget_name} heeft het budget met {current_percentage}% overschreden! Uitgegeven {spent_amount} van {budget_amount}',
                        'pl' => 'Przekroczenie budżetu: {budget_name} przekroczył budżet o {current_percentage}%! Wydano {spent_amount} z {budget_amount}',
                        'ru' => 'Превышение бюджета: {budget_name} превысил бюджет на {current_percentage}%! Потрачено {spent_amount} из {budget_amount}',
                        'pt' => 'Estouro de orçamento: {budget_name} excedeu o orçamento em {current_percentage}%! Gasto {spent_amount} de {budget_amount}',
                        'tr' => 'Bütçe aşımı: {budget_name} bütçeyi %{current_percentage} aştı! {budget_amount} içinden {spent_amount} harcanmış',
                        'pt-br' => 'Estouro de orçamento: {budget_name} excedeu o orçamento em {current_percentage}%! Gasto {spent_amount} de {budget_amount}',
                    ]
                ]
            ]
        ];

        foreach($notifications as $k => $n)
        {
            $ntfy = NotificationTemplates::where('slug',$k)->count();
            if($ntfy == 0)
            {
                $new = new NotificationTemplates();
                $new->name = $n;
                $new->slug = $k;
                $new->save();
            }else{
                $new = NotificationTemplates::where('slug',$k)->first();
            }

            foreach($defaultTemplate['notification'][$k]['lang'] as $lang => $content)
            {
                $notification = NotificationTemplateLangs::where('parent_id', $new->id)->where('lang', $lang)->count();
                if($notification==0){
                    NotificationTemplateLangs::create(
                        [
                            'parent_id' => $new->id,
                            'lang' => $lang,
                            'variables' => $defaultTemplate['notification'][$k]['variables'],
                            'content' => $content,
                            'created_by' =>1,
                        ]
                    );
                }
            }
        }
    }
}
