<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up()
    {
        // We strictly want lead specific quotations to avoid conflict with existing 'quotations' table
        if (!Schema::hasTable('lead_quotations')) {
            Schema::create('lead_quotations', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('lead_id');
                $table->decimal('total_amount', 15, 2)->default(0);
                $table->string('status')->default('draft');
                $table->integer('created_by')->default(0);
                $table->timestamps();
            });
        }

        if (!Schema::hasTable('lead_quotation_items')) {
            Schema::create('lead_quotation_items', function (Blueprint $table) {
                $table->id();
                $table->unsignedBigInteger('quotation_id');
                $table->string('floor_name')->nullable();
                $table->string('task_name');
                $table->string('material_spec')->nullable();
                $table->unsignedBigInteger('brand_id')->nullable();
                $table->string('unit')->nullable();
                $table->decimal('quantity', 15, 2)->default(0);
                $table->decimal('rate', 15, 2)->default(0);
                $table->decimal('amount', 15, 2)->default(0);
                $table->timestamps();
            });
        }
    }

    public function down()
    {
        Schema::dropIfExists('lead_quotation_items');
        Schema::dropIfExists('lead_quotations');
    }
};
