<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('brands')) {
            Schema::create('brands', function (Blueprint $table) {
                $table->id();
                $table->string('name');
                $table->string('category')->nullable(); // Cement, Steel, Paint
                $table->integer('created_by')->default(0);
                $table->timestamps();
            });
        }

        // We are moving to lead_quotations to avoid conflict
        // if (!Schema::hasTable('quotations')) { ... } 

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('quotation_items');
        Schema::dropIfExists('quotations');
        Schema::dropIfExists('brands');
    }
};
