<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('leads', function (Blueprint $table) {
            $table->string('project_type')->nullable()->after('subject'); // Residential, Commercial, Interior, Finishing
            $table->string('land_area')->nullable()->after('project_type');
            $table->integer('floors')->nullable()->after('land_area');
            $table->string('construction_standard')->nullable()->after('floors'); // Simple, Premium, Royal
            $table->integer('rooms')->nullable()->after('construction_standard');
            $table->integer('bathrooms')->nullable()->after('rooms');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('leads', function (Blueprint $table) {
            $table->dropColumn(['project_type', 'land_area', 'floors', 'construction_standard', 'rooms', 'bathrooms']);
        });
    }
};
