<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('construction_stages', function (Blueprint $table) {
            $table->unsignedBigInteger('construction_floor_id')->nullable()->after('project_id');
            $table->foreign('construction_floor_id')->references('id')->on('construction_floors')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('construction_stages', function (Blueprint $table) {
            $table->dropForeign(['construction_floor_id']);
            $table->dropColumn('construction_floor_id');
        });
    }
};
