<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('budget_alerts', function (Blueprint $table) {
            $table->text('notes')->nullable()->after('resolution_notes');
            $table->timestamp('resolved_at')->nullable()->after('acknowledged_by');
            $table->unsignedBigInteger('resolved_by')->nullable()->after('resolved_at');
            
            // Add foreign key for resolved_by
            $table->foreign('resolved_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('budget_alerts', function (Blueprint $table) {
            $table->dropForeign(['resolved_by']);
            $table->dropColumn(['notes', 'resolved_at', 'resolved_by']);
        });
    }
};
