<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('budget_alerts', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('budget_id');
            $table->decimal('threshold_percentage', 5, 2); // e.g., 5.00, 10.00, 15.00
            $table->decimal('current_percentage', 5, 2); // Current budget utilization percentage
            $table->decimal('budget_amount', 15, 2); // Total budget amount
            $table->decimal('spent_amount', 15, 2); // Amount spent so far
            $table->enum('alert_type', ['warning', 'critical', 'overrun']); // Type of alert
            $table->enum('status', ['active', 'acknowledged', 'resolved'])->default('active');
            $table->text('message')->nullable(); // Alert message
            $table->timestamp('triggered_at'); // When the alert was triggered
            $table->timestamp('acknowledged_at')->nullable(); // When the alert was acknowledged
            $table->unsignedBigInteger('acknowledged_by')->nullable(); // User who acknowledged
            $table->text('resolution_notes')->nullable(); // Notes when resolving the alert
            $table->integer('created_by')->default(0);
            $table->timestamps();
            
            // Foreign key constraints
            $table->foreign('budget_id')->references('id')->on('budgets')->onDelete('cascade');
            $table->foreign('acknowledged_by')->references('id')->on('users')->onDelete('set null');
            
            // Indexes for performance
            $table->index(['budget_id', 'status']);
            $table->index('triggered_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('budget_alerts');
    }
};
