<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('expense_categories', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->unsignedBigInteger('chart_account_id')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->text('description')->nullable();
            $table->timestamps();

            $table->foreign('chart_account_id')
                ->references('id')->on('chart_of_accounts')
                ->onDelete('set null');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('expense_categories');
    }
};