<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('product_services', function (Blueprint $table) {
            // Drop columns not needed for construction materials
            $table->dropColumn('sale_price');
            $table->dropColumn('type'); // No product/service distinction
            $table->dropColumn('sale_chartaccount_id');

            // Add brand column for material brand/manufacturer
            $table->string('brand')->nullable()->after('name');

            // Make purchase_price nullable (will be set during purchase)
            $table->decimal('purchase_price', 16, 2)->nullable()->change();

            // Add supplier reference
            $table->integer('supplier_id')->default(0)->after('category_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('product_services', function (Blueprint $table) {
            // Restore original columns
            $table->decimal('sale_price', 16, 2)->default(0)->after('sku');
            $table->string('type')->default('product')->after('unit_id');
            $table->integer('sale_chartaccount_id')->default(0)->after('type');

            // Remove construction-specific columns
            $table->dropColumn('brand');
            $table->dropColumn('supplier_id');

            // Restore purchase_price as NOT NULL
            $table->decimal('purchase_price', 16, 2)->default(0)->change();
        });
    }
};
