<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Rename main tables
        Schema::rename('product_services', 'materials');
        Schema::rename('product_service_categories', 'material_categories');
        Schema::rename('product_service_units', 'material_units');

        // Update foreign key columns in related tables
        if (Schema::hasTable('invoice_products')) {
            Schema::table('invoice_products', function (Blueprint $table) {
                if (Schema::hasColumn('invoice_products', 'product_id')) {
                    $table->renameColumn('product_id', 'material_id');
                }
            });
        }

        if (Schema::hasTable('bill_products')) {
            Schema::table('bill_products', function (Blueprint $table) {
                if (Schema::hasColumn('bill_products', 'product_id')) {
                    $table->renameColumn('product_id', 'material_id');
                }
            });
        }

        if (Schema::hasTable('proposal_products')) {
            Schema::table('proposal_products', function (Blueprint $table) {
                if (Schema::hasColumn('proposal_products', 'product_id')) {
                    $table->renameColumn('product_id', 'material_id');
                }
            });
        }

        if (Schema::hasTable('purchase_products')) {
            Schema::table('purchase_products', function (Blueprint $table) {
                if (Schema::hasColumn('purchase_products', 'product_id')) {
                    $table->renameColumn('product_id', 'material_id');
                }
            });
        }

        if (Schema::hasTable('quotation_products')) {
            Schema::table('quotation_products', function (Blueprint $table) {
                if (Schema::hasColumn('quotation_products', 'product_id')) {
                    $table->renameColumn('product_id', 'material_id');
                }
            });
        }

        if (Schema::hasTable('warehouse_products')) {
            Schema::table('warehouse_products', function (Blueprint $table) {
                if (Schema::hasColumn('warehouse_products', 'product_id')) {
                    $table->renameColumn('product_id', 'material_id');
                }
            });
        }

        if (Schema::hasTable('pos_products')) {
            Schema::table('pos_products', function (Blueprint $table) {
                if (Schema::hasColumn('pos_products', 'product_id')) {
                    $table->renameColumn('product_id', 'material_id');
                }
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // Reverse foreign key column renames
        if (Schema::hasTable('pos_products')) {
            Schema::table('pos_products', function (Blueprint $table) {
                if (Schema::hasColumn('pos_products', 'material_id')) {
                    $table->renameColumn('material_id', 'product_id');
                }
            });
        }

        if (Schema::hasTable('warehouse_products')) {
            Schema::table('warehouse_products', function (Blueprint $table) {
                if (Schema::hasColumn('warehouse_products', 'material_id')) {
                    $table->renameColumn('material_id', 'product_id');
                }
            });
        }

        if (Schema::hasTable('quotation_products')) {
            Schema::table('quotation_products', function (Blueprint $table) {
                if (Schema::hasColumn('quotation_products', 'material_id')) {
                    $table->renameColumn('material_id', 'product_id');
                }
            });
        }

        if (Schema::hasTable('purchase_products')) {
            Schema::table('purchase_products', function (Blueprint $table) {
                if (Schema::hasColumn('purchase_products', 'material_id')) {
                    $table->renameColumn('material_id', 'product_id');
                }
            });
        }

        if (Schema::hasTable('proposal_products')) {
            Schema::table('proposal_products', function (Blueprint $table) {
                if (Schema::hasColumn('proposal_products', 'material_id')) {
                    $table->renameColumn('material_id', 'product_id');
                }
            });
        }

        if (Schema::hasTable('bill_products')) {
            Schema::table('bill_products', function (Blueprint $table) {
                if (Schema::hasColumn('bill_products', 'material_id')) {
                    $table->renameColumn('material_id', 'product_id');
                }
            });
        }

        if (Schema::hasTable('invoice_products')) {
            Schema::table('invoice_products', function (Blueprint $table) {
                if (Schema::hasColumn('invoice_products', 'material_id')) {
                    $table->renameColumn('material_id', 'product_id');
                }
            });
        }

        // Reverse main table renames
        Schema::rename('material_units', 'product_service_units');
        Schema::rename('material_categories', 'product_service_categories');
        Schema::rename('materials', 'product_services');
    }
};
