<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('construction_activities', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('construction_stage_id');
            $table->unsignedBigInteger('project_id');
            $table->string('name');
            $table->text('description')->nullable();
            $table->decimal('estimated_cost', 15, 2)->nullable();
            $table->decimal('actual_cost', 15, 2)->nullable();
            $table->decimal('labor_hours', 8, 2)->nullable();
            $table->decimal('material_cost', 15, 2)->nullable();
            $table->decimal('equipment_cost', 15, 2)->nullable();
            $table->enum('status', ['pending', 'in_progress', 'completed', 'rework'])->default('pending');
            $table->integer('progress_percentage')->default(0);
            $table->text('assigned_to')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->unsignedBigInteger('created_by');
            $table->timestamps();

            $table->foreign('construction_stage_id')->references('id')->on('construction_stages')->onDelete('cascade');
            $table->foreign('project_id')->references('id')->on('projects')->onDelete('cascade');
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('construction_activities');
    }
};
