<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transaction_lines', function (Blueprint $table) {
            if (!Schema::hasColumn('transaction_lines', 'project_id')) {
                $table->unsignedBigInteger('project_id')->nullable()->index()->after('reference_sub_id');
            }
            if (!Schema::hasColumn('transaction_lines', 'project_task_id')) {
                $table->unsignedBigInteger('project_task_id')->nullable()->index()->after('project_id');
            }

            // Add foreign keys if the referenced tables exist
            if (Schema::hasTable('projects')) {
                $table->foreign('project_id')->references('id')->on('projects')->onDelete('set null');
            }
            if (Schema::hasTable('project_tasks')) {
                $table->foreign('project_task_id')->references('id')->on('project_tasks')->onDelete('set null');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transaction_lines', function (Blueprint $table) {
            if (Schema::hasColumn('transaction_lines', 'project_task_id')) {
                $table->dropForeign(['project_task_id']);
                $table->dropColumn('project_task_id');
            }
            if (Schema::hasColumn('transaction_lines', 'project_id')) {
                $table->dropForeign(['project_id']);
                $table->dropColumn('project_id');
            }
        });
    }
};