<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPettyCashFieldsToExpensesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('expenses', function (Blueprint $table) {
            // Add payment mode field
            $table->enum('payment_mode', ['bank', 'cash', 'petty_cash', 'cheque'])->default('bank')->after('amount');
            
            // Add petty cash allocation reference
            $table->unsignedBigInteger('petty_cash_allocation_id')->nullable()->after('payment_mode');
            
            // Add staff member reference for petty cash expenses
            $table->unsignedBigInteger('staff_id')->nullable()->after('petty_cash_allocation_id');

            // Foreign key constraints
            $table->foreign('petty_cash_allocation_id')->references('id')->on('petty_cash_allocations')->onDelete('set null');
            $table->foreign('staff_id')->references('id')->on('users')->onDelete('set null');

            // Indexes for better performance
            $table->index(['payment_mode', 'date']);
            $table->index('petty_cash_allocation_id');
            $table->index('staff_id');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('expenses', function (Blueprint $table) {
            // Drop foreign key constraints first
            $table->dropForeign(['petty_cash_allocation_id']);
            $table->dropForeign(['staff_id']);
            
            // Drop indexes
            $table->dropIndex(['payment_mode', 'date']);
            $table->dropIndex(['petty_cash_allocation_id']);
            $table->dropIndex(['staff_id']);
            
            // Drop columns
            $table->dropColumn(['payment_mode', 'petty_cash_allocation_id', 'staff_id']);
        });
    }
}