<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePettyCashAllocationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('petty_cash_allocations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('employee_id');
            $table->decimal('allocated_amount', 10, 2);
            $table->decimal('current_balance', 10, 2);
            $table->date('allocation_date');
            $table->unsignedBigInteger('allocated_by');
            $table->text('purpose')->nullable();
            $table->enum('status', ['active', 'closed', 'suspended'])->default('active');
            $table->timestamps();
            $table->softDeletes();

            // Foreign key constraints
            $table->foreign('employee_id')->references('id')->on('users')->onDelete('cascade');
            $table->foreign('allocated_by')->references('id')->on('users');

            // Indexes for better performance
            $table->index(['employee_id', 'status']);
            $table->index('allocation_date');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('petty_cash_allocations');
    }
}