<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LeadQuotationItem extends Model
{
    protected $table = 'lead_quotation_items'; // Use the table I just created

    protected $fillable = [
        'quotation_id',
        'floor_name',
        'task_name',
        'material_spec',
        'brand_id',
        'unit',
        'quantity',
        'rate',
        'amount',
    ];

    public function quotation()
    {
        return $this->belongsTo(LeadQuotation::class, 'quotation_id');
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class);
    }
}
