<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class LeadQuotation extends Model
{
    protected $table = 'lead_quotations';

    protected $fillable = [
        'lead_id',
        'total_amount',
        'status',
        'created_by',
    ];

    public function items()
    {
        return $this->hasMany(LeadQuotationItem::class, 'quotation_id');
    }

    public function lead()
    {
        return $this->belongsTo(Lead::class);
    }
}
