<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Expense extends Model
{
    protected $fillable = [
        'name',
        'date',
        'description',
        'amount',
        'attachment',
        'project_id',
        'task_id',
        'created_by',
        'payment_mode',
        'petty_cash_allocation_id',
        'staff_id',
    ];

    // Get Expense based task
    public function task()
    {
        return $this->hasOne('App\Models\ProjectTask', 'id', 'task_id');
    }

    // Get Expense based project
    public function project()
    {
        return $this->hasOne('App\Models\Project', 'id', 'project_id');
    }

    // Get Petty Cash Allocation
    public function pettyCashAllocation()
    {
        return $this->belongsTo(PettyCashAllocation::class, 'petty_cash_allocation_id');
    }

    // Get Staff member for petty cash expenses
    public function staff()
    {
        return $this->belongsTo(User::class, 'staff_id');
    }

    // Get Petty Cash Transaction
    public function pettyCashTransaction()
    {
        return $this->hasOne(PettyCashTransaction::class, 'expense_id');
    }

    // Check if expense is petty cash type
    public function isPettyCash()
    {
        return $this->payment_mode === 'petty_cash';
    }

    // Scope for petty cash expenses
    public function scopePettyCash($query)
    {
        return $query->where('payment_mode', 'petty_cash');
    }

}
