<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ConstructionFloor extends Model
{
    use HasFactory;

    protected $fillable = [
        'project_id',
        'name',
        'sequence_order',
        'description',
    ];

    public function project()
    {
        return $this->belongsTo(Project::class);
    }

    public function stages()
    {
        return $this->hasMany(ConstructionStage::class, 'construction_floor_id')->orderBy('sequence_order');
    }
}
