<?php

namespace App\Http\Controllers;

use App\Models\ChartOfAccount;
use App\Models\ExpenseCategory;
use Illuminate\Http\Request;

class ExpenseCategoryController extends Controller
{
    public function index()
    {
        if (!\Auth::user()->can('manage bill')) {
            return redirect()->back()->with('error', __('Permission Denied.'));
        }

        $categories = ExpenseCategory::where('created_by', \Auth::user()->creatorId())->orderBy('name')->get();

        $chartAccounts = ChartOfAccount::select(\DB::raw('CONCAT(code, " - ", name) AS code_name, id'))
            ->where('created_by', \Auth::user()->creatorId())->get()
            ->pluck('code_name', 'id');

        return view('expense_category.index', compact('categories', 'chartAccounts'));
    }

    public function store(Request $request)
    {
        if (!\Auth::user()->can('manage bill')) {
            return redirect()->back()->with('error', __('Permission Denied.'));
        }

        $request->validate([
            'name' => 'required|string|max:255',
            'chart_account_id' => 'nullable|exists:chart_of_accounts,id',
            'description' => 'nullable|string',
        ]);

        $category = new ExpenseCategory();
        $category->name = $request->name;
        $category->chart_account_id = $request->chart_account_id ?: null;
        $category->description = $request->description;
        $category->created_by = \Auth::user()->creatorId();
        $category->save();

        return redirect()->route('expense-categories.index')->with('success', __('Expense category created.'));
    }

    public function destroy(ExpenseCategory $expenseCategory)
    {
        if (!\Auth::user()->can('manage bill')) {
            return redirect()->back()->with('error', __('Permission Denied.'));
        }

        if ($expenseCategory->created_by != \Auth::user()->creatorId()) {
            return redirect()->back()->with('error', __('Permission Denied.'));
        }

        $expenseCategory->delete();

        return redirect()->route('expense-categories.index')->with('success', __('Expense category deleted.'));
    }
}