<?php

namespace App\Exports;

use App\Models\ProductService;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ProductServiceExport implements FromCollection, WithHeadings
{

    public function collection()
    {

        $data = ProductService::select('materials.id', 'materials.name as item',  'sku', 'purchase_price', 'tax_id as tax', 'material_categories.name as category', 'material_units.name as unit', 'description');
//        $data->leftjoin('venders', 'materials.assign_vendor', '=', 'venders.id');
        $data->leftjoin('material_categories', 'materials.category_id', '=', 'material_categories.id');
        $data->leftjoin('material_units', 'materials.unit_id', '=', 'material_units.id');
        $data= $data->where('materials.created_by', \Auth::user()->creatorId())->get();
        foreach($data as $k => $item)
        {
            $taxes                      = ProductService::taxData($item->tax);
            $data[$k]["purchase_price"] = \Auth::user()->priceFormat($item->purchase_price);
            $data[$k]["tax"]            = $taxes;
//            $data[$k]["stock_status"]   = ProductService::$stockStatus[$item->stock_status];
//            $data[$k]["image"]          = asset(\Storage::url('uploads/product')) . '/' . $item->image;
        }


        return $data;
    }

    public function headings(): array
    {
        return [
            "ID",
            "Name",
            "SKU",
            "purchase_price",
            "Tax",
            "Category",
            "Unit",
            "Description",
        ];
    }
}
