# Scope of Work (Blade Frontend)

## Overview
This scope defines deliverables for a Laravel-based Construction ERP using Blade templates and Vite-powered assets. The system covers projects, clients, finance, inventory, assets, accounting, and user management.

## Deliverables
- Blade UI: Layouts, partials, components, and pages for core modules.
- Controllers & Routes: Web routes for views; API routes for data services.
- Validation: Form requests for create/update flows.
- Assets: Vite-built `resources/js` and `resources/css` integrated via `@vite`.
- Localization: Multi-language support via `resources/lang`.
- Access Control: Role/permission checks at controllers and views.
- Testing: Feature tests for key user journeys.

## Feature Modules
- Projects: Create/edit/list, stages, activities, dashboards.
- Clients: Corporate/individual management, status and finance info.
- Financials: Quotations, payment milestones, expenses with approvals.
- Inventory: Vendors, materials, purchase orders, material issues.
- Assets: Asset registry and allotments.
- Accounting: Chart of accounts, journal entries.
- Alerts: Budget alerts configuration and notifications.

## UI Structure
- Layouts: `resources/views/layouts/app.blade.php` base layout.
- Partials: `resources/views/partials/{header,nav,footer}`.
- Components: `resources/views/components` for reusable elements.
- Pages: `resources/views/pages/{module}` per feature.

## Non-Functional Requirements
- Performance: Cache-heavy pages, paginate listings.
- Security: CSRF, input validation, auth guards, policy/gate checks.
- Accessibility: Semantic markup, keyboard navigation, ARIA where necessary.
- Internationalization: Language switcher and translated strings.

## Out of Scope
- SPA frameworks (Angular/React) and client-side routing.
- Complex real-time features beyond notifications if not specified.