# Functional Requirements Document — Document Management System (DMS)

---

## 1. Purpose

Provide a centralized, secure, searchable system to store, version, distribute, and control project documents (drawings, contracts, RFIs, submittals, transmittals, BOQs, photos, permits, O&M manuals, invoices) for small construction projects. The DMS must integrate with the existing Laravel 12 backend and Creative Tim Material Angular frontend and match the project's authentication, queues, storage and design constraints.

---

## 2. Scope

* All project-level documents across modules: Projects, Stages, Activities, Quotations, Purchase Orders, Assets, Petty Cash, Accounting.
* Attachments to RFIs, Submittals, Expenses, Purchase Orders, Assets, Journal Entries.
* Version control, access control, review/approval workflows, transmittals, markups, and search.
* Integration points: existing REST APIs, Angular components, file storage (Local/S3), queue jobs (Redis), and notifications.

---

## 3. Stakeholders

* Small builders / developers (project managers, site engineers)
* Architects / consultants
* Procurement / purchase teams
* Accountants / finance
* Admin / Super-admin
* Field staff (site foremen)

---

## 4. High-level Requirements (summary)

1. Document types support: PDF, DOCX, XLSX, DWG (viewer), images (JPG/PNG), ZIP, MP4.
2. Project-scoped storage with folder hierarchy + automatic metadata.
3. Version control with check-in/check-out and rollback.
4. Workflows: RFI, Submittal, Transmittal, Approval, Review, Commenting and Markups.
5. Access control: role-based + fine-grained ACLs.
6. Full-text search + metadata filters + DWG/Blueprint preview.
7. Audit trail and immutable logs for compliance.
8. Notifications (email + in-app) + scheduled retention and archival.
9. Integrations: link documents to existing API entities.
10. Data migration/import utilities and bulk upload with mapping.
11. Performance & scalability for small builders: minimal latency.

---

## 5. Functional Requirements (detailed)

### 5.1 Document Model & Metadata

* **Fields**: id, project_id, stage_id, activity_id, module, module_reference_id, filename, storage_path, mime_type, size, uploaded_by, uploaded_at, version_number, status, tags, title, description, revision_notes, expiry_date, confidential, checksum.
* **Metadata capture**: user, timestamp, project, discipline, contractor/vendor, drawing number, revision, issued_for, custom fields per project.
* **Naming conventions**: automatic stamping (drawing number + revision + project code).

### 5.2 Upload & Storage

* Bulk upload (zip + manifest.csv mapping), single upload via Angular form.
* Chunked/resumable uploads.
* Thumbnail generation + preview generation.
* Store original + derived versions.

### 5.3 Versioning & Locking

* Automatic version increment.
* Snapshot per version with rollback.
* Optional check-out/check-in locking.
* Approval metadata support.

### 5.4 Workflows

* **RFI**: create, attach docs, assign, track responses.
* **Submittal**: prepare, review, approve/reject.
* **Transmittal**: batch docs, create record, send external.
* **Approval**: multi-stage approval.
* **Comments & Markups**: inline, version-aware.

### 5.5 Security & Access Control

* Role-based + ACLs.
* Signed URLs for downloads.
* Encryption at rest/in transit.
* Immutable audit logs.

### 5.6 Search & Discovery

* Metadata filterable search.
* Full-text indexing for PDFs/Office docs.
* Saved searches.

### 5.7 Integrations & APIs

* Extend `/api/...` with document endpoints:

```
GET  /api/projects/{id}/documents
POST /api/projects/{id}/documents
GET  /api/documents/{id}
PUT  /api/documents/{id}
DELETE /api/documents/{id}
POST /api/documents/{id}/versions
GET  /api/documents/{id}/versions
POST /api/documents/{id}/checkout
POST /api/documents/{id}/checkin
POST /api/documents/bulk-upload
GET  /api/documents/search?q=...
POST /api/documents/{id}/share
```

* Notifications via `/api/notifications`.
* Link documents to entities via `module` + `module_reference_id`.

### 5.8 UI Components (Angular + Material)

* **Documents Page**: `mat-card` + `mat-table`.
* **Upload Dialog**: `mat-dialog` + `mat-stepper`.
* **Document Detail**: `mat-tabs` (Overview, Versions, Logs).
* **Version History**: `mat-list` with chips.
* **RFI/Submittal Forms**: `mat-stepper`.
* **Viewer Modal**: full-screen `mat-dialog`.
* **Search Bar**: `mat-form-field` with filters.

---

## 6. Non-Functional Requirements

* **Performance**: API <200ms; DB indexing.
* **Reliability**: daily backups, queue retries.
* **Security**: HTTPS, RBAC, audit logs.
* **Availability**: Local or S3 storage, Redis queues.

---

## 7. Data Model (sample simplified schema)

```sql
documents (
  id BIGINT PK,
  project_id BIGINT,
  stage_id BIGINT NULL,
  activity_id BIGINT NULL,
  module VARCHAR(50) NULL,
  module_reference_id BIGINT NULL,
  title VARCHAR(255),
  filename VARCHAR(255),
  storage_path VARCHAR(1024),
  mime_type VARCHAR(128),
  size BIGINT,
  uploaded_by BIGINT,
  uploaded_at TIMESTAMP,
  status VARCHAR(32) DEFAULT 'draft',
  confidential BOOLEAN DEFAULT FALSE,
  tags JSON,
  checksum VARCHAR(64),
  current_version_id BIGINT NULL,
  deleted_at TIMESTAMP NULL
)

document_versions (
  id BIGINT PK,
  document_id BIGINT,
  version_number INT,
  storage_path VARCHAR(1024),
  uploaded_by BIGINT,
  uploaded_at TIMESTAMP,
  revision_notes TEXT,
  approved_by BIGINT NULL,
  approved_at TIMESTAMP NULL
)

rfis (
  id, project_id, title, description, raised_by, assigned_to, status, due_date, linked_document_id
)

submittals (
  id, project_id, title, prepared_by, status, submitted_to, submitted_at, reviewed_at
)

transmittals (
  id, project_id, transmittal_number, sender_id, recipients JSON, documents JSON, sent_at
)

document_activity_logs (
  id, document_id, user_id, action, details JSON, ip_address, created_at
)
```

---

## 8. UX / Business Rules

* Approved versions cannot be deleted.
* External links expire.
* Auto-link docs on PO receipt.
* RFI escalation on overdue.
* Submittal approval auto-creates transmittal.

---

## 9. Reporting & Alerts

* Dashboards: documents by status, pending approvals.
* Alerts: pending RFIs, expiring docs.
* Export: CSV/PDF.

---

## 10. Migration, Testing & QA

* Bulk migration utility.
* Unit + feature tests.
* Usability testing with site staff.

---

## 11. Implementation Plan

* **Phase A — Core DMS**: entity, storage, versioning, ACLs, API, Angular list/detail.
* **Phase B — Workflows**: RFIs, Submittals, Transmittals, approvals, comments.
* **Phase C — Integrations**: link docs to other modules.
* **Phase D — Enhancements**: DWG viewer, OCR, stamping, reporting.

---

## 12. Deliverables

* OpenAPI spec for document endpoints.
* SQL migrations for core tables.
* Angular component map.
* Worker design for previews.
* Implementation checklist.
