# Architecture Overview

## Stack Summary
- Backend: Laravel 12 (PHP 8+)
- Frontend: Laravel Blade templates with Vite-built assets
- Database: MySQL 8.0+
- Caching/Queue: Redis (optional), Laravel Queue workers

## Application Layers
- Routes (`routes/web.php`, `routes/api.php`): Define web views and API endpoints.
- Controllers (`app/Http/Controllers`): Orchestrate requests, call services, return views or JSON.
- Requests (`app/Http/Requests`): Validate incoming data.
- Services (`app/Services`, if present): Encapsulate business logic.
- Models (`app/Models`): Eloquent models managing database persistence.
- Views (`resources/views`): Blade templates for server-rendered UI.
- Assets (`resources/js`, `resources/css`): Built with Vite; referenced via `@vite` in Blade.

## Frontend Structure (Blade)
- Base layout at `resources/views/layouts/app.blade.php`.
- Shared partials under `resources/views/partials` (header, nav, footer).
- Reusable Blade components under `resources/views/components`.
- Feature pages under `resources/views/pages/{feature}`.

## Data Flow
1. Browser requests a route.
2. Route maps to Controller method.
3. Controller invokes Services/Models for business/data logic.
4. Controller returns Blade view with data.
5. Blade renders HTML; Vite-built JS/CSS enhance UI where needed.

## Key Modules Present
- Payments integrations under `app/` (e.g., `Khalti`, `PayTab`, `Xendit`).
- Localization under `resources/lang` with multiple languages.
- Public assets under `public/assets`, scripts under `public/js`, styles under `public/css`.

## Build & Dev
- Use `vite.config.js` for asset building; include assets with `@vite()`.
- Legacy `webpack.mix.js` may exist; prefer Vite unless Mix is required.

## Testing & Quality
- Feature/Unit tests under `tests/`.
- Follow PSR standards; use Laravel Pint for formatting if configured.